(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    136886,       3799]*)
(*NotebookOutlinePosition[    138832,       3859]*)
(*  CellTagsIndexPosition[    138699,       3851]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Superficies. Integrales de superficie", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author",
  FontSize->12],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell[BoxData[{
    \(Off[ParametricPlot3D::ppcom]\), "\n", 
    \(Off[ParametricPlot::ppcom]\), "\n", 
    \(Off[General::spell1]\)}], "Input",
  InitializationCell->True],

Cell["<<Graphics`Arrow`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell["<<Graphics`Colors`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell[BoxData[
    \(\(\(norma[x_] := N[\@\(x . x\)]\  (*\ 
      norma\ eucl\[IAcute]dea\ del\ vector\ x\ *) \n
    \(\(normaliza[x_]\  := If[Simplify[x . x] == 0, x, \ x/norma[x]]; \  (*\ 
      vector\ unitario\ en\ la\ direcci\[OAcute]n\ del\ vector\ x\ *) \n
    normal3D[x_]\  := \ 
      normaliza[
        Which[x[\([1]\)] == 0, {1, 0, 
            0}, \((x[\([2]\)] \[NotEqual] 
                0)\) \[Or] \((x[\([3]\)] \[NotEqual] 0)\), {0, 
            x[\([3]\)], \(-x[\([2]\)]\)}, \((x[\([2]\)] == 0 \[And] 
              x[\([3]\)] == 0)\), {0, 1, 0}]]\)\(\n\)
    \)\)\( (*\ 
      un\ vector\ unitario\ ortogonal\ al\ vector\ x\ *) \)\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(\(arrow3D[x_, y_, color_:  RGBColor[0. , 0. , 0. ], 
          grosor_:  0.007] := \n\t\t\t{{color, Thickness[grosor], 
            Line[{x, y}]}, \n\ \ \ \ \ {SurfaceColor[
              color], \ \(Polygon[
                  Append[#, 
                    y]] &\)\  /@ \ \n\t\t\t\t\t\tPartition[\(\((y\ \  - \ 
                        0.18*\((y - x)\) + \ #)\) &\) /@ \((\((0.3*\ 0.18*
                          norma[y - x]*\ 
                          Table[{Cos[2\ k\ Pi/8. ], \ Sin[2\ k\ Pi/8. ]}, {k, 
                              0, 8}])\) . {normal3D[y - x], 
                        normaliza[Cross[normal3D[y - x], y - x]]})\), 2, 
                1]}};\)\), "\n", 
    \(\(\(vector3D[x_List: {0, 0, 0}, y_List, 
        color_:  RGBColor[0. , 0. , 0. ], grosor_:  0.007]\)\(:=\)\(arrow3D[
        x, x + y, color, grosor]\)\(\ \)\( (*\ 
        traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x\ *) \)\)\)}], "Input",\

  InitializationCell->True],

Cell["<<Graphics`Animation`", "Input",
  InitializationCell->True,
  CellTags->"S5.29.1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Superficies en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]]
}], "Section"],

Cell[TextData[{
  "En todo lo que sigue consideraremos funciones de una o varias variables \
con derivada continua o con derivadas parciales de primer orden continuas \
respectivamente. Las formas m\[AAcute]s frecuentes de definir una superficie \
en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " son las siguientes:\n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " La superficie viene dada por ",
  StyleBox["la gr\[AAcute]fica de una funci\[OAcute]n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", es decir, se trata de una superficie de la forma"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`S = \({\((x, y, z)\) \[Element] 
              \(\(\[DoubleStruckCapitalR]\^3\) : \ \((x, y)\) \[Element] A\), 
            \ z = f(x, y)} = {
            \((x, y, f(x, y))\) \[Element] 
              \(\(\[DoubleStruckCapitalR]\^3\) : \ \((x, y)\) \[Element] A\)}
            \)\)]],
  "    "
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde  ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \ \[DoubleStruckCapitalR]\^2\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " es un campo escalar de dos variables."
}], "Text"],

Cell[TextData[{
  StyleBox["b)",
    FontWeight->"Bold"],
  " La superficie est\[AAcute] ",
  StyleBox["definida impl\[IAcute]citamente",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " por una ecuaci\[OAcute]n, es decir, se trata de una superficie de la \
forma"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`S = {\((x, y, z)\) \[Element] 
              \(\(\[DoubleStruckCapitalR]\^3\) : g(x, y, z)\) = 0}\)]],
  " "
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es un campo escalar de tres variables."
}], "Text"],

Cell[TextData[{
  StyleBox["c)",
    FontWeight->"Bold"],
  " La superficie est\[AAcute] ",
  StyleBox["definida param\[EAcute]tricamente",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", es decir, se trata de una superficie de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`S = \[Gamma](A)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " es una funci\[OAcute]n de dos variables con valores en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". La funci\[OAcute]n \[Gamma] transforma un subconjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^\(2\ \)\)]],
  "en una superficie en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". En este caso se acostumbra a interpretar los puntos del conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " como par\[AAcute]metros que describen la superficie. Si notamos ",
  Cell[BoxData[
      \(TraditionalForm\`\((s, t)\) \[Element] A\)]],
  " un elemento gen\[EAcute]rico de ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ", la funci\[OAcute]n \[Gamma] debe ser de la forma"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(\[Gamma](s, t)\), "=", 
        RowBox[{\((x(s, t), y(s, t), z(s, t))\), "=", 
          RowBox[{
            RowBox[{\(x(s, t)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\(y(s, t)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(z(s, t)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y, por tanto ",
  Cell[BoxData[
      \(TraditionalForm
      \`S = \(\[Gamma](A) = {\((x(s, t), y(s, t), z(s, t))\), \ \ 
            \((s, t)\) \[Element] A}\)\)]],
  ". "
}], "Text"],

Cell[TextData[{
  "Observa que ",
  StyleBox["a)",
    FontWeight->"Bold"],
  " es un caso particular de ",
  StyleBox["b)",
    FontWeight->"Bold"],
  "  pues la gr\[AAcute]fica de una funci\[OAcute]n ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "es el conjunto de puntos donde se anula la funci\[OAcute]n de tres \
variables ",
  Cell[BoxData[
      \(TraditionalForm\`g(x, y, z) = f(x, y) - z\)]],
  ", y tambi\[EAcute]n es un caso particular de ",
  StyleBox["c)",
    FontWeight->"Bold"],
  "  pues ",
  StyleBox["la gr\[AAcute]fica de una funci\[OAcute]n  ",
    FontWeight->"Bold"],
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["  tiene como ecuaciones param\[EAcute]tricas  ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Gamma] \((x, y)\) = \((x, y, f(x, y))\)\),
          FontWeight->"Plain"], TraditionalForm]],
    FontWeight->"Bold"],
  ". "
}], "Text"],

Cell[TextData[{
  "Para cada uno de estos casos ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene un comando que permite representar la superficie dada:\n\
Plot3D[f[x,y],{x,a,b},{y,c,d},opciones]  representa la gr\[AAcute]fica de la \
funci\[OAcute]n",
  StyleBox[" f ",
    FontSlant->"Italic"],
  "en el intervalo [a,b]\[Times][c,d].\n\
ContourPlot3D[g[x,y,z],{x,xmin,xmax},{y,ymin,ymax},{z,zmin,zmax}, opciones] \
representa las superficies de nivel de la funci\[OAcute]n g[x,y,z], es decir \
las superficies de ecuaci\[OAcute]n impl\[IAcute]cita g[x,y,z]=c. Por defecto \
representa la superficie que corresponde al valor c=0. \n\
ParametricPlot3D[{x[s,t],y[s,t],z[s,t]},{s,a,b},{t,c,d},opciones]  representa \
la gr\[AAcute]fica de la superficie de ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](s, t) = \((x(s, t), y(s, t), 
          z(s, t))\)\)]],
  " para  ",
  Cell[BoxData[
      \(TraditionalForm\`\((s, 
          t)\) \[Element] \([a, b]\)\[Times]\([c, d]\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Plot3D[\ 
        x\ y\ Exp[\(-x\^2\) - y\^2], \ {x, \(-2\), 2}, {y, \(-2\), 2}, 
        PlotPoints -> 30, AxesLabel -> {X, Y, Z}];\)\)], "Input"],

Cell[BoxData[
    \(\(esfera = 
        ParametricPlot3D[{Cos[\[Phi]] Sin[\[Theta]], 
            Sin[\[Phi]] Sin[\[Theta]], 
            Cos[\[Theta]]}, {\[Phi], \(-\[Pi]\), \[Pi]}, {\[Theta], 
            0, \[Pi]}];\)\)], "Input"],

Cell["\<\
Controlando los par\[AAcute]metros puedes conseguir representar partes de la \
superficie. \
\>", "Text"],

Cell[BoxData[
    \(\(ParametricPlot3D[{Cos[\[Phi]] Sin[\[Theta]], 
          Sin[\[Phi]] Sin[\[Theta]], Cos[\[Theta]]}, {\[Phi], \(-\[Pi]\)/5, 
          3  \[Pi]/2}, {\[Theta], \[Pi]/8, \[Pi] - \[Pi]/8}];\)\)], "Input"],

Cell[TextData[{
  "Una forma interesante de ver la gr\[AAcute]fica de una funci\[OAcute]n es \
mediante curvas de nivel. Por este m\[EAcute]todo lo que se hace es \
representar la gr\[AAcute]fica de una funci\[OAcute]n en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " proyectando sobre el plano XY las curvas intersecci\[OAcute]n de dicha \
superficie con planos paralelos al plano XY (",
  StyleBox["curvas de nivel",
    FontWeight->"Bold"],
  "). Las curvas de nivel unen los puntos de la superficie que tienen la \
misma altura. Est\[AAcute]s acostumbrado a ver estas representaciones porque \
los mapas topogr\[AAcute]ficos representan el relieve del terreno por curvas \
de nivel. Esta representaci\[OAcute]n permite ver las zonas donde la funci\
\[OAcute]n var\[IAcute]a m\[AAcute]s r\[AAcute]pidamente porque las curvas de \
nivel est\[AAcute]n m\[AAcute]s pr\[OAcute]ximas entre s\[IAcute]. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un comando \"ContourPlot[f[x,y],{x,a,b},{y,c,d},opciones]\" \
que representa curvas de nivel de la gr\[AAcute]fica de la funci\[OAcute]n \
f[x,y] para una sucesi\[OAcute]n de valores de altura igualmente espaciados.  \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " representa con tonos m\[AAcute]s luminosos las zonas donde la funci\
\[OAcute]n toma valores m\[AAcute]s grandes y con tonos m\[AAcute]s oscuros \
las zonas donde la funci\[OAcute]n es m\[AAcute]s peque\[NTilde]a. Veamos el \
gr\[AAcute]fico de contorno de la primera superficie."
}], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\(ContourPlot[
        x\ y\ Exp[\(-x\^2\) - y\^2], {x, \(-2\), 2}, {y, \(-2\), 
          2}];\)\)], "Input"],

Cell[TextData[{
  "Las superficies m\[AAcute]s sencillas son las cu\[AAcute]dricas. Se llaman \
as\[IAcute] las superficies definidas impl\[IAcute]citamente como el conjunto \
de puntos donde se anula una funci\[OAcute]n polin\[OAcute]mica de grado dos \
con tres variables. Las cu\[AAcute]dricas son la generalizaci\[OAcute]n a ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " de las c\[OAcute]nicas."
}], "Text"],

Cell["\<\
Para representar superficies impl\[IAcute]citamente definidas hay que cargar \
el paquete siguiente que pone a nuestra disposici\[OAcute]n el comando \
ContourPlot3D[ ] que es el an\[AAcute]logo en tres dimensiones de \
ContourPlot[ ]. \
\>", "Text"],

Cell["<<Graphics`ContourPlot3D`", "Input",
  CellTags->"S5.30.1"],

Cell[BoxData[
    \(\(\(\(\(ContourPlot3D[
          2  x^2 + y^2 - z^2 - 
            1, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {x, \(-2\), 
            2}, \ {y, \(-2\), 2}, \ {z, \(-2\), 
            2}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ PlotPoints -> {{5, 7}, {5, 
                7}, {5, 7}}]\) \);\)\( (*\ 
      Hiperboloide\ de\ una\ hoja\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(ContourPlot3D[
        z\^2 + \((2 - \@\(x\^2 + y\^2\))\)\^2 - 
          1, \[IndentingNewLine]\t{x, \(-3\), 3}, {y, \(-3\), 3}, {z, \(-1\), 
          1}, \[IndentingNewLine]\t
        PlotPoints -> {{5, 7}, {5, 7}, {5, 7}}];\)\)], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "En el libro de James Stewart ",
  StyleBox["C\[AAcute]lculo Multivariable",
    FontSlant->"Italic"],
  " 4\.aa Ed. en la secci\[OAcute]n 12.6 (p\[AAcute]gina 824) figuran los \
distintos tipos de cu\[AAcute]dricas (elipsoides, paraboloides \
el\[IAcute]pticos, paraboloides hiperb\[OAcute]licos, conos, hiperboloides de \
una hoja e hiperboloides de dos hojas). Utiliza los comandos anteriores para \
representar cada una de ellas (necesitar\[AAcute]s elegir valores para los \
par\[AAcute]metros ",
  StyleBox["a, b, c",
    FontSlant->"Italic"],
  ")."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plano tangente en un punto de una superficie", "Subsection"],

Cell[TextData[{
  "Se dice que un vector ",
  Cell[BoxData[
      \(TraditionalForm\`w \[Element] \[DoubleStruckCapitalR]\^3\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "es tangente a una superficie ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\) \[Element] S\)]],
  " si se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " es el vector tangente en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  " a una curva contenida en ",
  StyleBox["S",
    FontSlant->"Italic"],
  " y que pasa por dicho punto. Se dice que un vector ",
  Cell[BoxData[
      \(TraditionalForm\`w \[Element] \[DoubleStruckCapitalR]\^3\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "es ortogonal a una superficie ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\) \[Element] S\)]],
  " si se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " es ortogonal a todo vector tangente a ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  ". \nSe verifica que el plano tangente a la superficie en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  " contiene a todos los vectores tangentes a la superficie en dicho punto. \
El c\[AAcute]lculo del plano tangente depende de c\[OAcute]mo venga dada la \
superficie. Consideremos los tres casos posibles."
}], "Text"],

Cell[TextData[{
  StyleBox["1",
    FontWeight->"Bold"],
  ") Supongamos que la superficie viene dada por ecuaciones \
param\[EAcute]tricas ",
  Cell[BoxData[
      \(TraditionalForm\`S = \[Gamma](A)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^2\)]],
  " y"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(\[Gamma](s, t)\), "=", 
        RowBox[{\((x(s, t), y(s, t), z(s, t))\), "=", 
          RowBox[{
            RowBox[{\(x(s, t)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\(y(s, t)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(z(s, t)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para calcular el plano tangente en un punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[Gamma]", "(", 
            FormBox[
              RowBox[{
                FormBox[\(s\_0\),
                  "TraditionalForm"], ",", \(t\_0\)}],
              "TraditionalForm"], ")"}], 
          "=", \(\((a, b, c)\) \[Element] \ S\)}], TraditionalForm]]],
  ", basta darse cuenta de que las curvas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha](s) = \[Gamma](s, t\_0)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta](t) = \[Gamma](s\_0, t)\)]],
  " est\[AAcute]n contenidas en ",
  StyleBox["S",
    FontSlant->"Italic"],
  " y pasan por el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  ". Los vectores tangentes a dichas curvas en ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  " vienen dados por "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Alpha]' \((s\_0)\)\), "=", 
        RowBox[{
          FormBox[
            RowBox[{\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\), 
              RowBox[{"(", 
                FormBox[
                  RowBox[{
                    FormBox[\(s\_0\),
                      "TraditionalForm"], ",", \(t\_0\)}],
                  "TraditionalForm"], ")"}]}],
            "TraditionalForm"], "=", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                FormBox[
                  RowBox[{\(\[PartialD]\ x\/\[PartialD]\ s\), 
                    RowBox[{"(", 
                      FormBox[
                        RowBox[{
                          FormBox[\(s\_0\),
                            "TraditionalForm"], ",", \(t\_0\)}],
                        "TraditionalForm"], ")"}]}],
                  "TraditionalForm"], ",", 
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\(\[PartialD]\ y\/\[PartialD]\ s\), 
                        RowBox[{"(", 
                          FormBox[
                            RowBox[{
                              FormBox[\(s\_0\),
                                "TraditionalForm"], ",", \(t\_0\)}],
                            "TraditionalForm"], ")"}]}], ","}],
                    "TraditionalForm"], 
                  FormBox[
                    RowBox[{\(\[PartialD]\ z\/\[PartialD]\ s\), 
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{
                            FormBox[\(s\_0\),
                              "TraditionalForm"], ",", \(t\_0\)}],
                          "TraditionalForm"], ")"}]}],
                    "TraditionalForm"]}]}], ")"}], "=", 
            RowBox[{
              RowBox[{
                FormBox[
                  RowBox[{\(\[PartialD]\ x\/\[PartialD]\ s\), 
                    RowBox[{"(", 
                      FormBox[
                        RowBox[{
                          FormBox[\(s\_0\),
                            "TraditionalForm"], ",", \(t\_0\)}],
                        "TraditionalForm"], ")"}]}],
                  "TraditionalForm"], 
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], 
              StyleBox["+",
                FontWeight->"Plain"], 
              RowBox[{
                FormBox[
                  RowBox[{\(\[PartialD]\ y\/\[PartialD]\ s\), 
                    FormBox[
                      RowBox[{
                        RowBox[{
                          RowBox[{"(", 
                            FormBox[
                              RowBox[{
                                FormBox[\(s\_0\),
                                  "TraditionalForm"], ",", \(t\_0\)}],
                              "TraditionalForm"], ")"}], 
                          StyleBox["j",
                            FontWeight->"Bold"]}], "+"}],
                      "TraditionalForm"]}],
                  "TraditionalForm"], 
                FormBox[
                  RowBox[{\(\[PartialD]\ z\/\[PartialD]\ s\), 
                    FormBox[
                      RowBox[{
                        RowBox[{"(", 
                          FormBox[
                            RowBox[{
                              FormBox[\(s\_0\),
                                "TraditionalForm"], ",", \(t\_0\)}],
                            "TraditionalForm"], ")"}], 
                        StyleBox["k",
                          FontWeight->"Bold"]}],
                      "TraditionalForm"]}],
                  "TraditionalForm"]}]}]}]}]}], TraditionalForm]], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Beta]\ ' \((t\_0)\)\), "=", 
        RowBox[{
          FormBox[
            RowBox[{\(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\), 
              RowBox[{"(", 
                FormBox[
                  RowBox[{
                    FormBox[\(s\_0\),
                      "TraditionalForm"], ",", \(t\_0\)}],
                  "TraditionalForm"], ")"}]}],
            "TraditionalForm"], "=", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  FormBox[
                    RowBox[{\(\[PartialD]\ x\/\[PartialD]\ t\), 
                      FormBox[
                        RowBox[{"(", 
                          FormBox[
                            RowBox[{
                              FormBox[\(s\_0\),
                                "TraditionalForm"], ",", \(t\_0\)}],
                            "TraditionalForm"], ")"}],
                        "TraditionalForm"]}],
                    "TraditionalForm"], 
                  FormBox[
                    RowBox[{",", 
                      RowBox[{\(\[PartialD]\ y\/\[PartialD]\ t\), 
                        RowBox[{"(", 
                          FormBox[
                            RowBox[{
                              FormBox[\(s\_0\),
                                "TraditionalForm"], ",", \(t\_0\)}],
                            "TraditionalForm"], ")"}]}]}],
                    "TraditionalForm"]}], ",", 
                FormBox[
                  RowBox[{\(\[PartialD]\ z\/\[PartialD]\ t\), 
                    FormBox[
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{
                            FormBox[\(s\_0\),
                              "TraditionalForm"], ",", \(t\_0\)}],
                          "TraditionalForm"], ")"}],
                      "TraditionalForm"]}],
                  "TraditionalForm"]}], ")"}], "=", 
            RowBox[{
              RowBox[{
                FormBox[
                  RowBox[{\(\[PartialD]\ x\/\[PartialD]\ t\), 
                    FormBox[
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{
                            FormBox[\(s\_0\),
                              "TraditionalForm"], ",", \(t\_0\)}],
                          "TraditionalForm"], ")"}],
                      "TraditionalForm"]}],
                  "TraditionalForm"], 
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], " ", "+", 
              RowBox[{
                FormBox[
                  RowBox[{\(\[PartialD]\ y\/\[PartialD]\ t\), 
                    RowBox[{"(", 
                      FormBox[
                        RowBox[{
                          FormBox[\(s\_0\),
                            "TraditionalForm"], ",", \(t\_0\)}],
                        "TraditionalForm"], ")"}]}],
                  "TraditionalForm"], " ", 
                StyleBox["j",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], " ", "+", 
              RowBox[{
                FormBox[
                  RowBox[{\(\[PartialD]\ z\/\[PartialD]\ t\), 
                    FormBox[
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{
                            FormBox[\(s\_0\),
                              "TraditionalForm"], ",", \(t\_0\)}],
                          "TraditionalForm"], ")"}],
                      "TraditionalForm"]}],
                  "TraditionalForm"], 
                StyleBox["k",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}]}]}]}], TraditionalForm]], "Text"],

Cell[TextData[{
  "que son los vectores columna de la matriz jacobiana de \[Gamma] en ",
  Cell[BoxData[
      \(TraditionalForm\`\((s\_0, t\_0)\)\)]],
  ". S",
  StyleBox[
  "e supone que dichos vectores son linealmente independientes pues en otro \
caso el plano tangente a ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  StyleBox[" en ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\((a, b, c)\),
          FontWeight->"Plain"], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[" no est\[AAcute] definido",
    FontWeight->"Bold"],
  ". El plano tangente a ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  " es la traslaci\[OAcute]n a dicho punto del plano vectorial engendrado por \
estos dos vectores. En consecuencia, el plano tangente tiene las ecuaciones \
param\[EAcute]tricas siguientes:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{" ", 
        RowBox[{\((x, y, z)\), "=", 
          RowBox[{
            RowBox[{"\[Gamma]", "(", 
              FormBox[
                RowBox[{
                  FormBox[\(s\_0\),
                    "TraditionalForm"], ",", \(t\_0\)}],
                "TraditionalForm"], ")"}], "+", 
            RowBox[{"s", 
              FormBox[
                RowBox[{\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\), 
                  FormBox[
                    RowBox[{"(", 
                      FormBox[
                        RowBox[{
                          FormBox[\(s\_0\),
                            "TraditionalForm"], ",", \(t\_0\)}],
                        "TraditionalForm"], ")"}],
                    "TraditionalForm"]}],
                "TraditionalForm"]}], " ", "+", " ", 
            RowBox[{"t", " ", \(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\), 
              FormBox[
                RowBox[{"(", 
                  FormBox[
                    RowBox[{
                      FormBox[\(s\_0\),
                        "TraditionalForm"], ",", \(t\_0\)}],
                    "TraditionalForm"], ")"}],
                "TraditionalForm"], 
              "                              ", \((s, 
                t \[Element] \[DoubleStruckCapitalR])\)}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["2)",
    FontWeight->"Bold"],
  " Supongamos que la superficie est\[AAcute] ",
  StyleBox["definida impl\[IAcute]citamente",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " por una ecuaci\[OAcute]n, es decir, se trata de una superficie de la \
forma ",
  Cell[BoxData[
      \(TraditionalForm\`S = {\((x, y, 
                z)\) \[Element] \(\(\[DoubleStruckCapitalR]\^3\) : 
                g(x, y, z)\) = 0}\)]],
  " donde ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es un campo escalar de tres variables. Para calcular el plano tangente a \
",
  StyleBox["S",
    FontSlant->"Italic"],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\) \[Element] S\)]],
  ", basta observar que el vector gradiente de ",
  StyleBox["g",
    FontSlant->"Italic"],
  " calculado en ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  " es ortogonal a todo vector tangente a ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  ". Ello es consecuencia de que si ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] : \([a, 
            b]\) \[Rule] \[DoubleStruckCapitalR]\^3\)]],
  " es una curva contenida en la superficie ",
  StyleBox["S",
    FontSlant->"Italic"],
  " que pasa por el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha](t\_0) = \((a, b, c)\)\)]],
  ", entonces se tiene que ",
  Cell[BoxData[
      \(TraditionalForm\`g(\[Alpha](t)) = 0\)]],
  " para todo",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(t \[Element] \([a, b]\)\)\)\)]],
  ", por lo que la derivada de la funci\[OAcute]n compuesta ",
  Cell[BoxData[
      \(TraditionalForm\`g(\[Alpha](t))\)]],
  " es id\[EAcute]nticamente nula, es decir ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\[Del]\(g(\[Alpha](
                  t))\) | \[Alpha]' \((t)\)\[RightAngleBracket] = 0\)]],
  " para todo",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(t \[Element] \([a, b]\)\)\)\)]],
  ", en particular, para ",
  Cell[BoxData[
      \(TraditionalForm\`t = t\_0\)]],
  " obtenemos que \[LeftAngleBracket]",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(g(a, b, c)\) | \[Alpha]' \((t\_0)\)\)]],
  "\[RightAngleBracket]",
  Cell[BoxData[
      \(TraditionalForm\`\(\(=\)\(0\)\)\)]],
  ". Deducimos que el plano tangente a ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  " es el plano que tiene como vector ortogonal ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(g(a, b, c)\)\)]],
  " y que pasa por el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  ". ",
  StyleBox["Se supone que ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Del]\(g(a, b, c)\) \[NotEqual] \ \((0, 0, 0)\)\),
          FontWeight->"Plain"], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[" pues en otro caso, el plano tangente en ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\((a, b, c)\),
          FontWeight->"Plain"], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[" no est\[AAcute] definido.",
    FontWeight->"Bold"],
  " En consecuencia, el plano tangente es el plano de ecuaci\[OAcute]n \
cartesiana"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\[LeftAngleBracket]\[Del]\(g(a, b, c)\) | \((x - a, 
            y - b, z - c)\)\[RightAngleBracket] = 0\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["3)",
    FontWeight->"Bold"],
  " Si la superficie es la gr\[AAcute]fica de una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`S = {\((x, y, 
              f(x, y))\) \[Element] \(\(\[DoubleStruckCapitalR]\^2\) : \ \
\((x, y)\) \[Element] A\)}\)]],
  " donde  ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \ \[DoubleStruckCapitalR]\^2\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " es un campo escalar de dos variables, entonces dicha superficie est\
\[AAcute] definida impl\[IAcute]tamente por la ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`g(x, y, z) = \(f(x, y) - z = 0\)\)]],
  ". Como consecuencia de lo visto en el punto anterior, el plano tangente en \
un punto",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\((a, b, 
          c)\) = \((a, b, f(a, b))\) \[Element] S\)\)\)]],
  " es el plano de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\[Del]\(g(a, b, c)\) | \((x - a, 
              y - b, z - f(a, b))\)\[RightAngleBracket] = 0\)]],
  " y, como, ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Del]\(g(a, b, c)\)\), "=", 
          
          FormBox[\(\((\(\[PartialD]\ f\/\[PartialD]\ x\) \((a, 
                  b)\), \(\[PartialD]\ f\/\[PartialD]\ y\) \((a, 
                  b)\), \(-1\))\)\(\ \)\),
            "TraditionalForm"]}], TraditionalForm]]],
  ", se sigue que la ecuaci\[OAcute]n del plano tangente es ",
  Cell[BoxData[
      \(TraditionalForm\`z - 
          c = \(\[PartialD]\ f\/\[PartialD]\ x\) \((a, 
              b)\) \((x - a)\) + \(\[PartialD]\ f\/\[PartialD]\ y\) \((a, 
              b)\) \((y - b)\)\)]],
  ".\nObserva que ",
  StyleBox["S ",
    FontSlant->"Italic"],
  "tiene como ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](x, y) = \((x, y, f(x, y))\)\)]],
  " por lo que los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, 
        0, \(\[PartialD]\ f\/\[PartialD]\ x\) \((a, b)\))\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\((0, 
        1, \(\[PartialD]\ f\/\[PartialD]\ y\) \((a, b)\))\)\)]],
  " son tangentes a ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  ".  El vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(\[PartialD]\ f\/\[PartialD]\ x\) \((a, 
            b)\), \(\[PartialD]\ f\/\[PartialD]\ y\) \((a, 
            b)\), \(-1\))\)\)]],
  " es ortogonal a dichos vectores, como debe ser seg\[UAcute]n lo dicho en \
el punto anterior."
}], "Text"],

Cell["Las siguientes gr\[AAcute]ficas ilustran estos conceptos.", "Text"],

Cell[BoxData[{
    \(\(\[Gamma][\[Theta]_, \[Phi]_] = {Cos[\[Phi]] Sin[\[Theta]], 
          Sin[\[Phi]] Sin[\[Theta]], Cos[\[Theta]]};\)\), "\n", 
    \(a = N[\[Pi]/3]; b = \(-N[\[Pi]/10]\);\), "\n", 
    \(\(p = \[Gamma][a, b];\)\), "\n", 
    \(\(v1 = 
        D[\[Gamma][\[Theta], \[Phi]], \[Theta]] /. {\[Theta] -> a, \[Phi] -> 
              b};\)\), "\n", 
    \(\(v2 = 
        D[\[Gamma][\[Theta], \[Phi]], \[Phi]] /. {\[Theta] -> a, \[Phi] -> 
              b};\)\), "\n", 
    \(\(curva1 = 
        ParametricPlot3D[\[Gamma][a, \[Phi]], {\[Phi], 0, 2  \[Pi]}, 
            DisplayFunction \[Rule] Identity] /. \ 
          Line[x_] \[Rule] {Hue[0], Thickness[ .01], Line[x]};\)\), "\n", 
    \(\(curva2 = 
        ParametricPlot3D[\[Gamma][\[Theta], b], {\[Theta], 0, \[Pi]}, 
            DisplayFunction \[Rule] Identity] /. \ 
          Line[x_] \[Rule] {Hue[ .6], Thickness[ .01], Line[x]};\)\), "\n", 
    \(\(vctng = 
        Graphics3D[{vector3D[p, v1, Yellow,  .01], 
            vector3D[p, v2, Yellow,  .01]}];\)\), "\n", 
    \(\(nrml = 
        Graphics3D[{vector3D[p, Cross[v1, v2], Magenta,  .01]}];\)\), "\n", 
    \(\(plntg = 
        ParametricPlot3D[\[Gamma][a, b] + s*v1 + 
            t*v2, \ {s, \(- .5\),  .5}, {t, \(- .5\),  .5}, 
          DisplayFunction \[Rule] Identity];\)\ \)}], "Input"],

Cell[BoxData[{
    \(\(Show[esfera, curva1, curva2, 
        DisplayFunction \[Rule] $DisplayFunction, Boxed -> False, 
        Axes -> False];\)\), "\n", 
    \(\(Print["\<Gr\[AAcute]ficas de la esfera \
S=\[Gamma]([0,2\[Pi]]\[Times][0,\[Pi]]) y de las curvas\n\[Theta]\[Rule]\
\[Gamma](\[Theta],b) (en azul), \[Phi]\[Rule]\[Gamma](a,\[Phi]) (en \
rojo)\>"];\)\)}], "Input"],

Cell[BoxData[{
    \(\(Show[esfera, curva1, curva2, vctng, 
        DisplayFunction \[Rule] $DisplayFunction, Boxed -> False, 
        Axes -> False];\)\), "\n", 
    \(\(Print["\<Gr\[AAcute]ficas de la esfera \
S=\[Gamma]([0,2\[Pi]]\[Times][0,\[Pi]]);\nde las curvas \[Theta]\[Rule]\
\[Gamma](\[Theta],b) (en azul), \[Phi]\[Rule]\[Gamma](a,\[Phi]) (en rojo)\ny \
de los vectores tangentes a dichas curvas en su punto de corte\>"];\)\)}], \
"Input"],

Cell[BoxData[{
    \(\(Show[esfera, curva1, curva2, plntg, vctng, 
        DisplayFunction \[Rule] $DisplayFunction, Boxed -> False, 
        Axes -> False];\)\), "\n", 
    \(\(Print["\<Gr\[AAcute]ficas de la esfera \
S=\[Gamma]([0,2\[Pi]]\[Times][0,\[Pi]]);\nde las curvas \[Theta]\[Rule]\
\[Gamma](\[Theta],b) (en azul), \[Phi]\[Rule]\[Gamma](a,\[Phi]) (en rojo);\n\
de los vectores tangentes a dichas curvas en su punto de corte\ny de una \
parte del plano tangente en dicho punto\>"];\)\)}], "Input"],

Cell[BoxData[{
    \(\(Show[esfera, curva1, curva2, plntg, vctng, nrml, 
        DisplayFunction \[Rule] $DisplayFunction, Boxed -> False, 
        Axes -> False, 
        ViewPoint -> {0.174, \ \(-2.944\), \ 1.659}];\)\), "\n", 
    \(\(Print["\<Gr\[AAcute]ficas de la esfera \
S=\[Gamma]([0,2\[Pi]]\[Times][0,\[Pi]]);\nde las curvas \[Theta]\[Rule]\
\[Gamma](\[Theta],b) (en azul), \[Phi]\[Rule]\[Gamma](a,\[Phi]) (en rojo);\n\
de los vectores tangentes a dichas curvas en su punto de corte;\nde una parte \
del plano tangente en dicho punto\ny del vector normal en dicho \
punto\>"];\)\)}], "Input"],

Cell[BoxData[
    \(Clear[esfera, curva1, curva2, plntg, vctng, nrml]\)], "Input"],

Cell[TextData[{
  "Si ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z)\)]],
  " es un campo escalar de tres variables, las superficies de \
ecuaci\[OAcute]n impl\[IAcute]cita ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = c\)]],
  " o, lo que es igual ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) - c = 0\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " es una constante, se llaman ",
  StyleBox["superficies de nivel",
    FontWeight->"Bold"],
  " (cuando el campo se interpreta como un potencial se llaman ",
  StyleBox["superficies equipotenciales",
    FontWeight->"Bold"],
  "). De lo dicho en ",
  StyleBox["2)",
    FontWeight->"Bold"],
  ", se sigue que el vector gradiente ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(f(x, y, z)\)\)]],
  " es ortogonal en todo punto",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \((x, y, z)\)\)\)]],
  " (en el que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(f(x, y, z)\) \[NotEqual] \ 0\)]],
  ") a la superficie de nivel que pasa por dicho punto. "
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Calcula las ecuaci\[OAcute]nes del plano tangente y de la recta normal a \
cada una de las siguientes superficies en el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " que se indica en cada caso.\na) ",
  Cell[BoxData[
      \(TraditionalForm\`\(z\^2 - 2\ x\^2 - 2  y\^2 - 12 = 0, \)\)]],
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`P = \(\((1, \(-1\), 4)\) . \)\)]],
  "\nb) ",
  Cell[BoxData[
      \(TraditionalForm\`z - log(x\^2 + y\^2) = 0\)]],
  ", \t",
  Cell[BoxData[
      \(TraditionalForm\`P = \(\((1, 0, 0)\) . \)\)]],
  "\nc) ",
  Cell[BoxData[
      \(TraditionalForm
      \`x\^2 + y\^2 + z\^3 - 2\ x + \ 4  y\  + 3\ z\  + 1 = 0\)]],
  ", \t",
  Cell[BoxData[
      \(TraditionalForm\`P = \(\((3, 4, \(-3\))\) . \)\)]],
  "\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](u, v)\), "=", 
          RowBox[{"(", 
            RowBox[{\(u + v\), ",", 
              RowBox[{"3", " ", 
                FormBox[\(u\^2\),
                  "TraditionalForm"]}], ",", " ", \(u - v\)}], ")"}]}], 
        TraditionalForm]]],
  ", \t",
  Cell[BoxData[
      \(TraditionalForm\`P = \(\((2, 3, 0)\) . \)\)]],
  "\ne) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](u, v)\), "=", 
          RowBox[{
            RowBox[{\((u\  + v)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", " ", 
            RowBox[{"u", " ", "cos", " ", "v", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"v", " ", "sen", " ", "u", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", \t",
  Cell[BoxData[
      \(TraditionalForm\`P = \(\((1, 1, 0)\) . \)\)]]
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
\[CapitalAAcute]rea de una superficie. Integral de superficie de un campo \
escalar\
\>", "Section"],

Cell[TextData[{
  "Consideremos una superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S = \[Gamma](A)\)]],
  " donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](s, t)\), "=", 
          RowBox[{\((x(s, t), y(s, t), z(s, t))\), "=", 
            RowBox[{
              RowBox[{\(x(s, t)\), 
                StyleBox["i",
                  FontWeight->"Bold"]}], " ", "+", " ", 
              RowBox[{\(y(s, t)\), 
                StyleBox["j",
                  FontWeight->"Bold"]}], "+", 
              RowBox[{\(z(s, t)\), 
                StyleBox["k",
                  FontWeight->"Bold"]}]}]}]}], TraditionalForm]]],
  " y ",
  StyleBox["A",
    FontSlant->"Italic"],
  " es un subconjunto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " que, por sencillez, supondremos que es de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`A = \([a, b]\)\[Times]\([c, d]\)\)]],
  ". En todo lo que sigue se supone que la parametrizaci\[OAcute]n \[Gamma] \
es ",
  StyleBox["buena",
    FontSlant->"Italic"],
  " en el sentido de que solamente recubre la superficie una sola vez, esto \
es tanto como exigir que \[Gamma] sea una funci\[OAcute]n inyectiva aunque \
puede permitirse que en ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " haya algunas curvas que se recubran m\[AAcute]s de una vez por \[Gamma]."
}], "Text"],

Cell[TextData[{
  "Consideremos particiones ",
  Cell[BoxData[
      \(TraditionalForm
      \`a = \(\(s\_0 < s\_1 < s\_2 <  ... \) < s\_\(n - 1\) < s\_n = b\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm
      \`c = \(\(t\_0 < t\_1 < t\_2 <  ... \) < t\_\(m - 1\) < t\_m = d\)\)]],
  " de los intervalos",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \([a, b]\)\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\([c, d]\)\)]],
  " respectivamente. Tenemos que"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{"S", "=", 
        RowBox[{
          RowBox[{
            StyleBox["\[Gamma]",
              FontSlant->"Plain"], "(", "A", ")"}], "=", 
          RowBox[{
            RowBox[{
              StyleBox["\[Gamma]",
                FontSlant->"Plain"], "(", 
              RowBox[{
                FormBox[
                  RowBox[{
                    UnderscriptBox["\[Union]", 
                      RowBox[{
                        StyleBox["1",
                          FontSlant->"Plain"], 
                        StyleBox["\[LessEqual]",
                          FontSlant->"Plain"], 
                        StyleBox["j",
                          FontSlant->"Plain"], 
                        StyleBox["\[LessEqual]",
                          FontSlant->"Plain"], 
                        StyleBox[\(n\n1\),
                          FontSlant->"Plain"], 
                        StyleBox["\[LessEqual]",
                          FontSlant->"Plain"], 
                        StyleBox["k",
                          FontSlant->"Plain"], 
                        StyleBox["\[LessEqual]",
                          FontSlant->"Plain"], 
                        StyleBox["m",
                          FontSlant->"Plain"]}]], 
                    RowBox[{
                      RowBox[{"[", 
                        RowBox[{
                          SubscriptBox["s", 
                            StyleBox[\(j - 1\),
                              FontSlant->"Plain"]], ",", 
                          SubscriptBox["s", 
                            StyleBox["j",
                              FontSlant->"Plain"]]}], "]"}], 
                      StyleBox["\[Times]",
                        FontSlant->"Plain"]}]}],
                  "TraditionalForm"], "[", 
                RowBox[{
                  SubscriptBox["t", 
                    StyleBox[\(k - 1\),
                      FontSlant->"Plain"]], ",", 
                  SubscriptBox["t", 
                    StyleBox["k",
                      FontSlant->"Plain"]]}], "]"}], ")"}], 
            StyleBox["=",
              FontSlant->"Plain"], 
            RowBox[{
              UnderscriptBox["\[Union]", 
                RowBox[{
                  StyleBox["1",
                    FontSlant->"Plain"], 
                  StyleBox["\[LessEqual]",
                    FontSlant->"Plain"], 
                  StyleBox["j",
                    FontSlant->"Plain"], 
                  StyleBox["\[LessEqual]",
                    FontSlant->"Plain"], 
                  StyleBox[\(n\n1\),
                    FontSlant->"Plain"], 
                  StyleBox["\[LessEqual]",
                    FontSlant->"Plain"], 
                  StyleBox["k",
                    FontSlant->"Plain"], 
                  StyleBox["\[LessEqual]",
                    FontSlant->"Plain"], 
                  StyleBox["m",
                    FontSlant->"Plain"]}]], 
              RowBox[{
                StyleBox["\[Gamma]",
                  FontSlant->"Plain"], 
                StyleBox["(",
                  FontSlant->"Plain"], 
                RowBox[{
                  RowBox[{"[", 
                    RowBox[{
                      SubscriptBox["s", 
                        StyleBox[\(j - 1\),
                          FontSlant->"Plain"]], ",", 
                      SubscriptBox["s", 
                        StyleBox["j",
                          FontSlant->"Plain"]]}], "]"}], 
                  StyleBox["\[Times]",
                    FontSlant->"Plain"], 
                  RowBox[{"[", 
                    RowBox[{
                      SubscriptBox["t", 
                        StyleBox[\(k - 1\),
                          FontSlant->"Plain"]], ",", 
                      SubscriptBox["t", 
                        StyleBox["k",
                          FontSlant->"Plain"]]}], "]"}]}], ")"}]}]}]}]}], 
      TraditionalForm]]]], "Text",
  TextAlignment->Center,
  FontSlant->"Italic"],

Cell["\<\
teniendo en cuenta la propiedad aditiva del \[AAcute]rea, se sigue que\
\>", "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\[CapitalAAcute]rea \((S)\)\), "=", 
          RowBox[{
            
            FormBox[\(\[Sum]\+\(j = 1\)\%n\(\[Sum]\+\(k = 1\)\%m \
\[CapitalAAcute]rea\)\),
              "TraditionalForm"], 
            FormBox[
              RowBox[{"(", 
                RowBox[{
                  StyleBox["\[Gamma]",
                    FontSlant->"Plain"], 
                  StyleBox["(",
                    FontSlant->"Plain"], 
                  RowBox[{
                    RowBox[{"[", 
                      RowBox[{
                        SubscriptBox["s", 
                          StyleBox[\(j - 1\),
                            FontSlant->"Plain"]], ",", 
                        SubscriptBox["s", 
                          StyleBox["j",
                            FontSlant->"Plain"]]}], "]"}], 
                    StyleBox["\[Times]",
                      FontSlant->"Plain"], 
                    RowBox[{"[", 
                      RowBox[{
                        SubscriptBox["t", 
                          StyleBox[\(k - 1\),
                            FontSlant->"Plain"]], ",", 
                        SubscriptBox["t", 
                          StyleBox["k",
                            FontSlant->"Plain"]]}], "]"}]}], ")"}], ")"}],
              "TraditionalForm"], \((1)\)}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "A continuaci\[OAcute]n calcularemos de forma aproximada el \[AAcute]rea de \
un peque\[NTilde]o trozo de la superficie. Para ello sean ",
  StyleBox["h",
    FontSlant->"Italic"],
  " y ",
  StyleBox["k",
    FontSlant->"Italic"],
  " n\[UAcute]meros \"muy peque\[NTilde]os\" y consideremos el trozo de \
superficie ",
  Cell[BoxData[
      \(TraditionalForm
      \`S\_0 = \[Gamma](\([s\_0, s\_0 + h]\)\[Times]\([t\_0, t\_0 + k]\))
          \)]],
  ". Aproximaremos dicha superficie por el paralelogramo con v\[EAcute]rtice \
en ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma][s\_0, t\_0]\)]],
  " engendrado por los vectores ",
  Cell[BoxData[
      \(TraditionalForm
      \`v1 = \[Gamma][s\_0 + h, t\_0] - \[Gamma][s\_0, t\_0]\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm
      \`v2 = \[Gamma][s\_0, t\_0 + k] - \[Gamma][s\_0, t\_0]\)]],
  ". Sabemos que el \[AAcute]rea de dicho paralelogramo viene dada por la \
norma del producto vectorial de v1 por v2. Teniendo en cuenta la definici\
\[OAcute]n de derivada parcial, podemos hacer las siguientes aproximaciones:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{"v1", "\[TildeEqual]", 
            RowBox[{"h", " ", 
              
              FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\) \((s\_0, 
                    t\_0)\)\),
                "TraditionalForm"]}]}], ",", 
          FormBox[
            RowBox[{"v2", "\[TildeEqual]", 
              RowBox[{"k", " ", 
                
                FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\) \((s\_0, 
                      t\_0)\)\),
                  "TraditionalForm"]}]}],
            "TraditionalForm"]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "por lo que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
        "||", \(v1\[Times]v2\), "||", \(\(\[TildeEqual]\)\(h\ k\)\), " ", "||",
           
          RowBox[{
            FormBox[
              
              FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\) \((s\_0, 
                    t\_0)\)\),
                "TraditionalForm"],
              "TraditionalForm"], "\[Times]", 
            FormBox[
              
              FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\) \((s\_0, 
                    t\_0)\)\),
                "TraditionalForm"],
              "TraditionalForm"]}], "||"}], TraditionalForm]]],
  ". Observa que lo que estamos haciendo es aproximar el \[AAcute]rea de ",
  Cell[BoxData[
      \(TraditionalForm\`S\_0\)]],
  " por el \[AAcute]rea de un paralelogramo contenido en el plano tangente a \
",
  Cell[BoxData[
      \(TraditionalForm\`S\_0\)]],
  " en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](s\_0, t\_0)\)]],
  ". Es decir, para medir el \[AAcute]rea de ",
  Cell[BoxData[
      \(TraditionalForm\`S\_0\)]],
  " lo que hacemos es sustituir ",
  Cell[BoxData[
      \(TraditionalForm\`S\_0\)]],
  " por su proyecci\[OAcute]n sobre dicho plano tangente. \nEsto no debe de \
extra\[NTilde]arte: t\[UAcute] vives sobre la superficie de la tierra que es \
parecida a una esfera pero te comportas como si vivieras sobre un plano: el \
plano tangente a la Tierra en tu lugar de residencia. Por ejemplo, para medir \
el \[AAcute]rea de una regi\[OAcute]n cuadrada cuyo lado es de 5 \
kil\[OAcute]metros, no se tiene en cuenta la peque\[NTilde]a curvatura de \
dicha regi\[OAcute]n y afirmamos que el \[AAcute]rea es de 25 \
kil\[OAcute]metros cuadrados; lo que hacemos es aproximar un trozo de la \
esfera \"Tierra\" por un trozo de su plano tangente. El error que se comete \
es muy peque\[NTilde]o. Si pudi\[EAcute]ramos tapizar la superficie de la \
Tierra con teselas de 1 cent\[IAcute]metro de lado, bastar\[IAcute]a conocer \
cu\[AAcute]ntas teselas se necesitan para tener una buena \
aproximaci\[OAcute]n del \[AAcute]rea de la superficie total de la Tierra. La \
siguiente gr\[AAcute]fica ilustra estas ideas."
}], "Text"],

Cell[BoxData[{
    \(\(\[Gamma][\[Theta]_, \[Phi]_] = {Cos[\[Phi]] Sin[\[Theta]], 
          Sin[\[Phi]] Sin[\[Theta]], Cos[\[Theta]]};\)\), "\n", 
    \(\(semiesfera = 
        ParametricPlot3D[{Cos[\[Phi]] Sin[\[Theta]], 
            Sin[\[Phi]] Sin[\[Theta]], Cos[\[Theta]], EdgeForm[]}, {\[Theta], 
            0, \[Pi]/2}, {\[Phi], 0, 2  \[Pi]}, PlotPoints -> {20, 40}, 
          Boxed -> False, Axes -> False, 
          DisplayFunction -> Identity];\)\), "\n", 
    \(so = N[\[Pi]/5]; to = \(-N[\[Pi]/4]\); k =  .65; h =  .9*k;\), "\n", 
    \(\(curva1 = 
        ParametricPlot3D[\[Gamma][so, \[Phi]], {\[Phi], to, to + k}, 
            DisplayFunction -> Identity] /. \ 
          Line[x_] \[Rule] {Hue[ .6], Thickness[ .007], Line[x]};\)\), "\n", 
    \(\(curva2 = 
        ParametricPlot3D[\[Gamma][\[Theta], to + k], {\[Theta], so, so + h}, 
            DisplayFunction -> Identity] /. \ 
          Line[x_] \[Rule] {Hue[ .6], Thickness[ .007], Line[x]};\)\), "\n", 
    \(\(curva3 = 
        ParametricPlot3D[\[Gamma][so + h, \[Phi]], {\[Phi], to + k, to}, 
            DisplayFunction -> Identity] /. \ 
          Line[x_] \[Rule] {Hue[ .6], Thickness[ .007], Line[x]};\)\), "\n", 
    \(\(curva4 = 
        ParametricPlot3D[\[Gamma][\[Theta], to], {\[Theta], so + h, so}, 
            DisplayFunction -> Identity] /. \ 
          Line[x_] \[Rule] {Hue[ .6], Thickness[ .007], Line[x]};\)\), "\n", 
    \(\(punto = 
        Graphics3D[{Hue[0], PointSize[ .03], 
            Point[\[Gamma][so, to]]}];\)\), "\n", 
    \(\(vector1 = 
        Graphics3D[{vector3D[\[Gamma][so, 
                to],  .5 
                   D[\[Gamma][\[Theta], \[Phi]], \[Theta]] /. {\[Theta] -> 
                    so, \[Phi] -> to}, Yellow,  .01]}];\)\), "\n", 
    \(\(vector2 = 
        Graphics3D[{vector3D[\[Gamma][so, 
                to],  .75 
                   D[\[Gamma][\[Theta], \[Phi]], \[Phi]] /. {\[Theta] -> 
                    so, \[Phi] -> to}, Yellow,  .01]}];\)\), "\n", 
    \(\(plano = 
        Insert[ParametricPlot3D[\[Gamma][so, to] + 
              s*Evaluate[
                  D[\[Gamma][\[Theta], \[Phi]], \[Theta]] /. {\[Theta] -> 
                        so, \[Phi] -> to}] + 
              t*Evaluate[
                  D[\[Gamma][\[Theta], \[Phi]], \[Phi]] /. {\[Theta] -> 
                        so, \[Phi] -> to}], {s, 0,  .5}, {t, 0,  .75}, 
            PlotPoints -> {3, 3}, DisplayFunction -> Identity], 
          EdgeForm[Hue[0]], {1, 1}];\)\), "\n", 
    \(\(Show[semiesfera, curva1, curva2, curva3, curva4, punto, vector1, 
        vector2, plano, \ ImageSize -> {478.125, \ 408.75}, 
        DisplayFunction -> $DisplayFunction];\)\), "\n", 
    \(\(Print["\<Un trozo de una superficie aproximado por un trozo del plano \
tangente\>"];\)\)}], "Input"],

Cell["Teniendo ahora en cuenta la igualdad (1), deducimos que", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[CapitalAAcute]rea \((S)\)\), "=", 
        RowBox[{
          RowBox[{
            
            FormBox[\(\[Sum]\+\(j = 1\)\%n\(\[Sum]\+\(k = 1\)\%m \
\[CapitalAAcute]rea\)\),
              "TraditionalForm"], 
            RowBox[{"(", 
              FormBox[
                RowBox[{
                  StyleBox["\[Gamma]",
                    FontSlant->"Plain"], 
                  StyleBox["(",
                    FontSlant->"Plain"], 
                  RowBox[{
                    RowBox[{"[", 
                      RowBox[{
                        SubscriptBox["s", 
                          StyleBox[\(j - 1\),
                            FontSlant->"Plain"]], ",", 
                        SubscriptBox["s", 
                          StyleBox["j",
                            FontSlant->"Plain"]]}], "]"}], 
                    StyleBox["\[Times]",
                      FontSlant->"Plain"], 
                    RowBox[{"[", 
                      RowBox[{
                        SubscriptBox["t", 
                          StyleBox[\(k - 1\),
                            FontSlant->"Plain"]], ",", 
                        SubscriptBox["t", 
                          StyleBox["k",
                            FontSlant->"Plain"]]}], "]"}]}], ")"}],
                "TraditionalForm"], ")"}]}], "\[TildeEqual]", 
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[\(\[Sum]\+\(j = 1\)\%n\[Sum]\+\(k = 1\)\%m\),
                  
                  "TraditionalForm"], \((s\_j - s\_\(j - 1\))\), \((t\_k - 
                    t\_\(k - 1\))\)}],
              "TraditionalForm"], 
            FormBox[
              RowBox[{"||", 
                RowBox[{
                  FormBox[
                    
                    FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                              s\) \((s\_\(j - 1\), t\_\(k - 1\))\)\),
                      "TraditionalForm"],
                    "TraditionalForm"], "\[Times]", 
                  FormBox[
                    
                    FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                              t\) \((s\_\(j - 1\), t\_\(k - 1\))\)\),
                      "TraditionalForm"],
                    "TraditionalForm"]}], "||"}],
              "TraditionalForm"]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En el l\[IAcute]mite estas sumas convergen a la integral doble ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{\(\[Integral]\[Integral]\_A\), "||", 
              RowBox[{
                FormBox[
                  
                  FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\) \((s, 
                        t)\)\),
                    "TraditionalForm"],
                  "TraditionalForm"], "\[Times]", 
                FormBox[
                  
                  FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\) \((s, 
                        t)\)\),
                    "TraditionalForm"],
                  "TraditionalForm"]}], "||"}],
            "TraditionalForm"], \(\[DifferentialD]\((s, t)\)\)}], 
        TraditionalForm]]],
  ". Esto lleva a definir el \[AAcute]rea de una superficie ",
  StyleBox["S ",
    FontSlant->"Italic"],
  "dada param\[EAcute]tricamente por"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\[CapitalAAcute]rea \((S)\)\), "=", 
          FormBox[
            RowBox[{
              FormBox[
                RowBox[{\(\[Integral]\[Integral]\_A\), "||", 
                  RowBox[{
                    FormBox[
                      
                      FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                                s\) \((s, t)\)\),
                        "TraditionalForm"],
                      "TraditionalForm"], "\[Times]", 
                    FormBox[
                      
                      FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                                t\) \((s, t)\)\),
                        "TraditionalForm"],
                      "TraditionalForm"]}], "||"}],
                "TraditionalForm"], \(\[DifferentialD]\((s, t)\)\)}],
            "TraditionalForm"]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Si la superficie es la gr\[AAcute]fica de una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`S = {\((x, y, f(x, y))\) \[Element] 
            \(\(\[DoubleStruckCapitalR]\^2\) : \ \((x, y)\) \[Element] A\)}
          \)]],
  " donde  ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \ \[DoubleStruckCapitalR]\^2\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " es un campo escalar de dos variables, entonces dicha superficie tiene \
como ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](x, y) = \((x, y, f(x, y))\)\)]],
  " por lo que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\[PartialD]\ \[Gamma]\/\[PartialD]\ x\) \((x, y)\) = 
        \((1, 0, \(\[PartialD]\ f\/\[PartialD]\ x\) \((x, y)\))\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\[PartialD]\ \[Gamma]\/\[PartialD]\ y\) \((x, y)\) = 
        \((0, 1, \(\[PartialD]\ f\/\[PartialD]\ y\) \((x, y)\))\)\)]],
  ". En este caso tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\[CapitalAAcute]rea \((S)\)\), "=", 
          RowBox[{
            FormBox[
              RowBox[{
                RowBox[{
                  FormBox[
                    RowBox[{\(\[Integral]\[Integral]\_A\), "||", 
                      RowBox[{
                        FormBox[
                          
                          FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                                    x\) \((x, y)\)\),
                            "TraditionalForm"],
                          "TraditionalForm"], "\[Times]", 
                        FormBox[
                          
                          FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                                    y\) \((x, y)\)\),
                            "TraditionalForm"],
                          "TraditionalForm"]}], "||"}],
                    "TraditionalForm"], \(\[DifferentialD]\((x, y)\)\)}], 
                "=", \(\[Integral]\(\[Integral]\_A\@\( 1 + \((\(\[PartialD]\ \
f\/\[PartialD]\ x\) \((x, y)\))\)\^2 + \((\(\[PartialD]\ f\/\[PartialD]\ y\) \
\((x, y)\))\)\^2\)\)\)}],
              "TraditionalForm"], "  ", \(\[DifferentialD]\((x, y)\)\)}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "Calcula las siguientes \[AAcute]reas.\na) De la parte del plano ",
  Cell[BoxData[
      \(TraditionalForm\`x\/a + y\/b + z\/c = 1\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\((a > 0, b > 0, c > 0)\)\)]],
  " que se encuentra en el primer octante.\nb) De la gr\[AAcute]fica de la \
funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\^2\)]],
  ", definida por",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\^2 + y\^2\)]],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\) \[Element] A\)]],
  " donde ",
  StyleBox["A",
    FontSlant->"Italic"],
  " es el c\[IAcute]rculo de centro el origen y radio 1.\nc) De la parte de \
la semiesfera ",
  Cell[BoxData[
      \(TraditionalForm\`z = \@\(R\^2 - x\^2 - y\^2\)\)]],
  " limitada por el cilindro circular recto ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = r\^2\)]],
  " (se supone que ",
  Cell[BoxData[
      \(TraditionalForm\`R > r\)]],
  ").\nd) De la superficie (un toro) ",
  Cell[BoxData[
      \(TraditionalForm
      \`S = \[Gamma](\([0, 2  \[Pi]]\)\[Times]\([0, 2  \[Pi]]\))\)]],
  " donde "
}], "ExerciseText"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](s, 
          t) = \((\((R\  + \ r\ cos\ t)\)\ cos\ s, \ \((R\  + \ 
                r\ cos\ t)\)\ sen\ s, \ r\ sen\ t)\)\)]],
  "\tdonde ",
  Cell[BoxData[
      \(TraditionalForm\`0 < r < R\)]],
  "."
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "e) De la parte de la esfera ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 + z\^2 = a\^2\)]],
  " que se encuentra dentro del cilindro ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\/a\^2 + y\^2\/b\^2 = 1, \ b \[LessEqual] a, 
      \)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`z \[GreaterEqual] 0. \)]],
  "\nf) De la superficie ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", \(u, v\), ")"}], "=", 
          RowBox[{
            RowBox[{"u", " ", "cos", " ", "v", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"u", " ", "sen", " ", "v", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"v", 
              StyleBox[" ",
                FontWeight->"Bold"], 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] u \[LessEqual] 1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] v \[LessEqual] \[Pi]\)]],
  ".\ng) De la superficie ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", \(u, v\), ")"}], "=", 
          RowBox[{
            RowBox[{"u", "  ", "v", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\((u\  + \ v\ )\), 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\((u - v)\), 
              StyleBox[" ",
                FontWeight->"Bold"], 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`u\^2 + v\^2 \[LessEqual] 1\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integral de superficie de un campo escalar", "Subsection"],

Cell[TextData[{
  "Supongamos ahora que ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "es un campo escalar definido en una regi\[OAcute]n del espacio que \
contiene a la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S = \[Gamma](A)\)]],
  ". Para definir la integral de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " sobre ",
  StyleBox["S",
    FontSlant->"Italic"],
  ", procedemos como antes dividiendo la superficie en peque\[NTilde]os \
parches ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(S\_\(j, k\)\), "=", 
          RowBox[{
            StyleBox["\[Gamma]",
              FontSlant->"Plain"], 
            StyleBox["(",
              FontSlant->"Plain"], 
            RowBox[{
              RowBox[{"[", 
                RowBox[{
                  SubscriptBox["s", 
                    StyleBox[\(j - 1\),
                      FontSlant->"Plain"]], ",", 
                  SubscriptBox["s", 
                    StyleBox["j",
                      FontSlant->"Plain"]]}], "]"}], 
              StyleBox["\[Times]",
                FontSlant->"Plain"], 
              RowBox[{"[", 
                RowBox[{
                  SubscriptBox["t", 
                    StyleBox[\(k - 1\),
                      FontSlant->"Plain"]], ",", 
                  SubscriptBox["t", 
                    StyleBox["k",
                      FontSlant->"Plain"]]}], "]"}]}], ")"}]}], 
        TraditionalForm]]],
  ", evaluamos la funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en un punto de cada parche, por ejemplo en ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](s\_\(j - 1\), t\_\(k - 1\))\)]],
  ", y formamos la suma "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          
          FormBox[\(\[Sum]\+\(j = 1\)\%n\(\[Sum]\+\(k = 1\)\%m\( 
                    f(\[Gamma](s\_\(j - 1\), 
                      t\_\(k - 1\)))\) \[CapitalAAcute]rea\)\),
            "TraditionalForm"], 
          FormBox[
            RowBox[{"(", 
              RowBox[{
                StyleBox["\[Gamma]",
                  FontSlant->"Plain"], 
                StyleBox["(",
                  FontSlant->"Plain"], 
                RowBox[{
                  RowBox[{"[", 
                    RowBox[{
                      SubscriptBox["s", 
                        StyleBox[\(j - 1\),
                          FontSlant->"Plain"]], ",", 
                      SubscriptBox["s", 
                        StyleBox["j",
                          FontSlant->"Plain"]]}], "]"}], 
                  StyleBox["\[Times]",
                    FontSlant->"Plain"], 
                  RowBox[{"[", 
                    RowBox[{
                      SubscriptBox["t", 
                        StyleBox[\(k - 1\),
                          FontSlant->"Plain"]], ",", 
                      SubscriptBox["t", 
                        StyleBox["k",
                          FontSlant->"Plain"]]}], "]"}]}], ")"}], ")"}],
            "TraditionalForm"]}], "\[TildeEqual]", 
        FormBox[
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[\(\[Sum]\+\(j = 1\)\%n\[Sum]\+\(k = 1\)\%m\),
                  
                  "TraditionalForm"], \((s\_j - s\_\(j - 1\))\), \((t\_k - 
                    t\_\(k - 1\))\)}],
              "TraditionalForm"], \(f(\[Gamma](s\_\(j - 1\), t\_\(k - 1\)))\),
             
            FormBox[
              RowBox[{"||", 
                RowBox[{
                  FormBox[
                    
                    FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                              s\) \((s\_\(j - 1\), t\_\(k - 1\))\)\),
                      "TraditionalForm"],
                    "TraditionalForm"], "\[Times]", 
                  FormBox[
                    
                    FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                              t\) \((s\_\(j - 1\), t\_\(k - 1\))\)\),
                      "TraditionalForm"],
                    "TraditionalForm"]}], "||"}],
              "TraditionalForm"]}],
          "TraditionalForm"]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En el l\[IAcute]mite estas sumas convergen a la integral doble ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\(\[Integral]\_A f(\[Gamma](s, t))\)\), "||", 
          RowBox[{
            FormBox[
              
              FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\) 
                  \((s, t)\)\),
                "TraditionalForm"],
              "TraditionalForm"], "\[Times]", 
            FormBox[
              
              FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\) 
                  \((s, t)\)\),
                "TraditionalForm"],
              "TraditionalForm"]}], "||", \(\[DifferentialD]\((s, t)\)\)}], 
        TraditionalForm]]],
  ". Definimos, por tanto, la integral del campo escalar ",
  StyleBox["f",
    FontSlant->"Italic"],
  " sobre la superficie ",
  StyleBox["S",
    FontSlant->"Italic"],
  " como"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          
          RowBox[{\(\[Integral]\(\[Integral]\_S\( f(x, y, 
                    z)\) \[DifferentialD]S\)\), "=", 
            
            RowBox[{\(\[Integral]\(\[Integral]\_A f(\[Gamma](s, t))\)\), "||",
               
              RowBox[{
                FormBox[
                  
                  FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\) \((s, 
                        t)\)\),
                    "TraditionalForm"],
                  "TraditionalForm"], "\[Times]", 
                FormBox[
                  
                  FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\) \((s, 
                        t)\)\),
                    "TraditionalForm"],
                  "TraditionalForm"]}], 
              "||", \(\[DifferentialD]\((s, t)\)\)}]}],
          "TraditionalForm"], "                           ", \((1)\)}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En el caso paricular de que la superficie sea la gr\[AAcute]fica de una \
funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`S = {\((x, y, h(x, y))\) \[Element] 
            \(\(\[DoubleStruckCapitalR]\^2\) : \ \((x, y)\) \[Element] A\)}
          \)]],
  " donde  ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \ \[DoubleStruckCapitalR]\^2\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`h : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " es un campo escalar de dos variables, tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[\(\[Integral]\(\[Integral]\_S\( f(x, y, 
                  z)\) \[DifferentialD]S\) = \[Integral]\(\[Integral]\_A\( f(
                  x, y, h(x, 
                    y))\) \(\@\(1 + \((\(\[PartialD]\ h\/\[PartialD]\ x\) \
\((x, y)\))\)\^2 + \((\(\[PartialD]\ h\/\[PartialD]\ y\) \((x, y)\))\)\^2\)\) \
\[DifferentialD]\((x, y)\)\)\),
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Te recuerdo que estamos suponiendo que todas las funciones que \
consideramos son de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  ", es decir que tienen derivadas parciales de primer orden continuas. Las \
superficies definidas por funciones de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  "que tienen plano tangente en todo punto se llaman ",
  StyleBox["superficies suaves",
    FontWeight->"Bold"],
  ". Con frecuencia es preciso calcular integrales sobre superficies que \
tienen aristas y no son suaves pero que son \"suaves a trozos\" esto es, que \
se obtienen \"pegando\" varias superficies suaves; por ejemplo, la superficie \
formada por las caras de un poliedro. En tal caso, ",
  StyleBox["la integral sobre una superficie suave a trozos se define como la \
suma de las integrales sobre cada una de las superficies suaves que la \
forman",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell["\<\
Naturalmente, el valor de la integral (1) no debe depender de la forma en que \
representemos la superficie. Efectivamente, esto es as\[IAcute]. \
Ve\[AAcute]moslo con un ejemplo.\
\>", "Text"],

Cell[TextData[{
  "Calculemos la integral de superficie del campo escalar ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          FormBox[\(f(x, y, z) = \(\(y\)\(\ \)\)\^2 + z\),
            "TraditionalForm"], "2"], TraditionalForm]]],
  " en la superficie dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](u, v)\), "=", 
          RowBox[{
            RowBox[{"u", " ", "v", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((u + v)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((u - v)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`u\^2 + v\^2 \[LessEqual] 1\)]],
  ". Aqu\[IAcute] el conjunto ",
  StyleBox["A",
    FontSlant->"Italic"],
  " donde se mueven los par\[AAcute]metros es el disco unidad en el plano ",
  Cell[BoxData[
      FormBox[
        RowBox[{"A", "=", 
          RowBox[{"{", 
            RowBox[{\((u, v)\), ":", " ", 
              FormBox[\(u\^2 + v\^2 \[LessEqual] 1\),
                "TraditionalForm"]}], "}"}]}], TraditionalForm]]],
  ". Por tanto podemos calcular la integral como sigue."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(f[{x_, y_, z_}] = \ y\^2 + z\^2;\)\), "\[IndentingNewLine]", 
    \(\(\[Gamma][u_, v_] = {u*v, \ u + v, 
          u - v};\)\), "\[IndentingNewLine]", 
    \(Integrate[
      Simplify[f[\[Gamma][u, v]] 
          Norm[Cross[D[\[Gamma][u, v], u], 
              D[\[Gamma][u, v], v]]]], {u, \(-1\), 
        1}, {v, \(-\@\(1 - u\^2\)\), \@\(1 - u\^2\)}]\)}], "Input"],

Cell[BoxData[
    \(\(-\(4\/15\)\)\ \((\(-16\) + 3\ \@6)\)\ \[Pi]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Pero tambi\[EAcute]n podemos parametrizar la superficie dada por medio de \
las coordenadas polares de ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v)\)\)]],
  " en la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi](\[Rho], \[Theta]) = {\(\[Rho]\^2\) 
            cos\ \[Theta]\ sen\ \[Theta], \ \[Rho](
            cos\ \[Theta] + \ 
              sen\ \[Theta]), \ \[Rho]\ \((cos\ \[Theta]\  - \ 
                sen\ \[Theta])\)}\)]],
  ". De esta forma complicamos un poco la funci\[OAcute]n que nos da la \
superficie pero en cambio simplificamos mucho el conjunto donde se mueven los \
par\[AAcute]metros, pues ahora tenemos que dicho conjunto es ",
  Cell[BoxData[
      \(TraditionalForm\`B = {\((\[Rho], \[Theta])\) : 
            0 \[LessEqual] \[Rho] \[LessEqual] 1, \ 
          0 \[LessEqual] \[Theta] \[LessEqual] 2  \[Pi]}\)]],
  ". Por tanto podemos calcular la integral pedida en la forma siguiente."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\[Phi][\[Rho]_, \[Theta]_] = {\(\[Rho]\^2\) 
            Cos[\[Theta]]\ Sin[\[Theta]], \[Rho] \((Cos[\[Theta]] + 
                Sin[\[Theta]])\), \[Rho] \((Cos[\[Theta]] - 
                Sin[\[Theta]])\)};\)\), "\[IndentingNewLine]", 
    \(Integrate[
      Simplify[f[\[Phi][\[Rho], \[Theta]]]] 
        Norm[Cross[D[\[Phi][\[Rho], \[Theta]], \[Rho]], 
            D[\[Phi][\[Rho], \[Theta]], \[Theta]]]], {\[Rho], 0, 
        1}, {\[Theta], 0, 2\ \[Pi]}]\)}], "Input"],

Cell[BoxData[
    \(\(-\(4\/15\)\)\ \((\(-16\) + 3\ \@6)\)\ \[Pi]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Como puedes ver el resultado obtenido es el mismo. La explicaci\[OAcute]n \
de por qu\[EAcute] esto es as\[IAcute] radica en en un propiedad muy especial \
del producto vectorial. Consideremos la situaci\[OAcute]n general. Sea pues, \
una superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " dada por ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](s, t) = \((x(s, t), y(s, t), 
          z(s, t))\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\((s, t)\) \[Element] 
        A \[Subset] \[DoubleStruckCapitalR]\^2\)]],
  " e introduzcamos par\[AAcute]metros nuevos ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v)\)\)]],
  " por ",
  Cell[BoxData[
      \(TraditionalForm\`s = \[Alpha](u, v), \ t = \[Beta](u, v)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v)\) \[Element] B\)]],
  " siendo ",
  Cell[BoxData[
      \(TraditionalForm\`B = {\((u, 
              v)\) : \((\[Alpha](u, v), \[Beta](u, v))\) \[Element] A}\)]],
  ". Pongamos ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi](u, 
          v) = \[Gamma](\[Alpha](u, v), \[Beta](u, v))\)]],
  " la nueva parametrizaci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ". Probaremos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\(\[Integral]\(\[Integral]\_A 
                  f(\[Gamma](s, 
                    t))\) || \(\[PartialD]\[Gamma]\/\[PartialD]s\) \((s, 
                t)\)\[Times]\(\[PartialD]\[Gamma]\/\[PartialD]t\) \((s, 
                t)\) || \[DifferentialD]\((s, t)\)\),
          "TraditionalForm"], " ", 
        "=", \(\[Integral]\(\[Integral]\_B 
                f(\[Phi](u, 
                  v))\) || \(\[PartialD]\[Phi]\/\[PartialD]u\) \((u, 
              v)\)\[Times]\(\[PartialD]\[Phi]\/\[PartialD]v\) \((u, 
              v)\) || \[DifferentialD]\((u, 
                v)\)\ \ \ \ \ \ \ \ \ \ \ \((2)\)\)}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["Tenemos que", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\(\[Integral]\(\[Integral]\_A 
                  f(\[Gamma](s, 
                    t))\) || \(\[PartialD]\[Gamma]\/\[PartialD]s\) \((s, 
                t)\)\[Times]\(\[PartialD]\[Gamma]\/\[PartialD]t\) \((s, 
                t)\) || \[DifferentialD]\((s, t)\)\),
          "TraditionalForm"], " ", "=", 
        RowBox[{\((teorema\ del\ cambio\ de\ variables\ en\ integrales\ \
\(dobles : \ 
                expresamos\ la\ funci\[OAcute]n\ que\ integramos\ en\ las\ \
nuevas\ variables\ y\ multiplicamos\ por\ el\ jacobiano\))\), "=", 
          "\[IndentingNewLine]", 
          
          RowBox[{\(\[Integral]\(\[Integral]\_B 
                      f(\[Gamma](s, 
                        t))\) || \(\[PartialD]\[Gamma]\/\[PartialD]s\) \((s, 
                    t)\)\[Times]\(\[PartialD]\[Gamma]\/\[PartialD]t\) \((s, 
                    t)\) ||  /. {s, 
                  t} \[Rule] {\[Alpha](u, v), \[Beta](u, v)}\ \  | 
                  jacobiano(u, v) | \[DifferentialD]\((u, v)\)\), "=", 
            
            RowBox[{\(\[Integral]\(\[Integral]\_B 
                      f(\[Phi](u, 
                        v))\) || \(\[PartialD]\[Gamma]\/\[PartialD]s\) \((\
\[Alpha](u, v), \[Beta](u, 
                      v))\)\[Times]\(\[PartialD]\[Gamma]\/\[PartialD]t\) \((\
\[Alpha](u, v), \[Beta](u, v))\) || \), "  ", 
              StyleBox["|",
                FontWeight->"Bold",
                FontSlant->"Italic"], \(jacobiano(u, v)\), 
              StyleBox["|",
                FontWeight->"Bold"], \(\[DifferentialD]\((u, v)\)\)}]}]}]}], 
      TraditionalForm]], "Text"],

Cell["\<\
La igualdad (2) la obtenemos ahora como consecuencia de la siguiente igualdad\
\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\[PartialD]\[Phi]\/\[PartialD]u\) \((u, 
          v)\)\[Times]\(\[PartialD]\[Phi]\/\[PartialD]v\) \((u, 
          v)\) = \(\(jacobiano(u, 
          v)\) \(\[PartialD]\[Gamma]\/\[PartialD]s\) \((\[Alpha](u, 
            v), \[Beta](u, 
            v))\)\(\[Times]\)\(\[PartialD]\[Gamma]\/\[PartialD]t\) \
\((\[Alpha](u, v), \[Beta](u, v))\)\(\ \ \ \)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "que vamos a probar seguidamente con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[\[Gamma], \[Phi], \[Alpha], \[Beta]]\), "\[IndentingNewLine]", 
    \(\[Gamma][s_, 
        t_] = {\[Gamma]1[s, t], \[Gamma]2[s, t], \[Gamma]3[s, t]};  (*\ 
      parametrizaci\[OAcute]n\ inicial\ de\ la\ superficie\ \
*) \[IndentingNewLine]\[Phi][u_, 
        v_] = \[Gamma][\[Alpha][u, v], \[Beta][u, v]]; (*\ 
      nueva\ parametrizaci\[OAcute]n\ *) \), "\[IndentingNewLine]", 
    \(\(jacobiano[u_, v_] = 
        D[\[Alpha][u, v], u]*D[\[Beta][u, v], v] - 
          D[\[Alpha][u, v], v]*
            D[\[Beta][u, v], u];\)\), "\[IndentingNewLine]", 
    \(\(Cross[D[\[Phi][u, v], u], D[\[Phi][u, v], v]] // 
        Simplify;\)\), "\n", 
    \(\(jacobiano[u, 
              v]*\((Cross[D[\[Gamma][s, t], s], 
                D[\[Gamma][s, t], t]])\) /. {s \[Rule] \[Alpha][u, v], 
            t \[Rule] \[Beta][u, v]} // Simplify;\)\), "\n", 
    \(Simplify[%% \[Equal] %]\)}], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplos", "Subsection"],

Cell[TextData[{
  StyleBox["Centro de masa de una superficie",
    FontWeight->"Bold"],
  ". \nSea ",
  Cell[BoxData[
      \(TraditionalForm\`S = \[Gamma](A)\)]],
  " una superficie y sea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] : S \[Rule] \[DoubleStruckCapitalR]\)]],
  " una funci\[OAcute]n continua que representa la densidad superficial de \
una l\[AAcute]mina cuya forma es la de la superficie ",
  StyleBox["S",
    FontSlant->"Italic"],
  ", es decir, ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Rho](x, y, z)\ \)\)]],
  "es la densidad de ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en el punto",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \((x, y, z)\)\)\)]],
  " medida en unidades de masa por superficie (por ejemplo, en ",
  Cell[BoxData[
      \(TraditionalForm\`gr/cm\^2\)]],
  "). La masa total de la superficie viene dada por la integral de superficie \
de la funci\[OAcute]n \[Rho] sobre ",
  StyleBox["S",
    FontSlant->"Italic"],
  ". El centro de masa de ",
  StyleBox["S",
    FontSlant->"Italic"],
  " es el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((a, b, c)\)\ \)\)]],
  "definido por"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`a = \(\[Integral]\(\[Integral]x\ \(\[Rho](x, y, z)\) \
\[DifferentialD]S\)\)\/\(\[Integral]\(\[Integral]\(\[Rho](x, y, z)\) \
\[DifferentialD]S\)\), \ 
    b = \(\[Integral]\(\[Integral]y\ \(\[Rho](x, y, z)\) \
\[DifferentialD]S\)\)\/\(\[Integral]\(\[Integral]\(\[Rho](x, y, z)\) \
\[DifferentialD]S\)\), \ 
    c = \(\[Integral]\(\[Integral]z\ \(\[Rho](x, y, z)\) \
\[DifferentialD]S\)\)\/\(\[Integral]\(\[Integral]\(\[Rho](x, y, z)\) \
\[DifferentialD]S\)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Cuando la densidad es constante el centro de masas se denomina ",
  StyleBox["centroide ",
    FontWeight->"Bold"],
  "(que es una propiedad geom\[EAcute]trica de la superficie)."
}], "Text"],

Cell[TextData[{
  StyleBox[
  "F\[OAcute]rmula de Pappus para calcular el \[AAcute]rea de una superficie \
de revoluci\[OAcute]n",
    FontWeight->"Bold"],
  ". \nEste resultado establece que el \[AAcute]rea de la superficie de \
revoluci\[OAcute]n obtenida girando una curva plana simple alrededor de una \
recta que no la corta situada en su mismo plano es igual al producto de la \
longitud de la curva por la longitud de la circunferencia que describe el \
centroide de la misma. \nVamos a probar la afirmaci\[OAcute]n anterior. \
Supongamos, por comodidad, que la curva est\[AAcute] contenida en el plano XZ \
y viene dada por ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha](t) = \((x(t), z(t))\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] t \[LessEqual] b\)]],
  ". Suponemos tambi\[EAcute]n que ",
  Cell[BoxData[
      \(TraditionalForm\`z \((t)\) > 0\)]],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Element] \([a, b]\)\)]],
  ". Observa que estas hip\[OAcute]tesis no son restrictivas pues el caso \
general puede reducirse a \[EAcute]ste mediante un giro y una traslaci\
\[OAcute]n que son movimientos del espacio que conservan las \[AAcute]reas. \
Al girar la curva alrededor del eje X se obtiene una superficie de revoluci\
\[OAcute]n ",
  StyleBox["S",
    FontSlant->"Italic"],
  " que est\[AAcute] dada por ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma](s, t) = 
        \((x(t)\ , \ \(z(t)\)\ cos\ s, \ \(z(t)\)\ sen\ s)\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] t \[LessEqual] b\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] s \[LessEqual] 2  \[Pi]\)]],
  "."
}], "Text"],

Cell["\<\
Aqu\[IAcute] puedes ver un trozo de una c\[UAcute]bica y la superficie de \
revoluci\[OAcute]n obtenida gir\[AAcute]ndolo alrededor del eje X.\
\>", "Text"],

Cell[BoxData[{
    \(\(ParametricPlot[{t, \ 1 + \((t - 1)\)\^3}, {t, 0, 2}, 
        PlotRange -> {{\(- .1\), 2}, All}, 
        AxesLabel -> {"\<X\>", "\<Z\>"}];\)\), "\n", 
    \(\(ParametricPlot3D[{t, \((\ 1 + \((t - 1)\)\^3)\) 
            Cos[s], \((\ 1 + \((t - 1)\)\^3)\) Sin[s]}, {t, 0, 2}, {s, 0, 
          2  \[Pi]}, AxesLabel -> {"\<X\>", "\<Y\>", "\<Z\>"}, 
        PlotRange -> {{\(- .1\), 2}, {\(-2.1\), 2.1}, {\(-2.1\), 2.1}}, 
        AspectRatio -> Automatic, BoxRatios -> {1.5, 1, 1}, 
        Axes -> False];\)\)}], "Input"],

Cell[BoxData[{
    \(\(\[Gamma][s_, t_] = {x[t], z[t] Cos[s], z[t] Sin[s]};\)\), "\n", 
    \(\@\(Cross[D[\[Gamma][s, t], s], D[\[Gamma][s, t], t]] . \
Cross[D[\[Gamma][s, t], s], D[\[Gamma][s, t], t]]\) // Simplify\)}], "Input"],

Cell[TextData[{
  "Deducimos que, el \[AAcute]rea de la superficie ",
  StyleBox["S",
    FontSlant->"Italic"],
  " viene dada por"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\[CapitalAAcute]rea \((S)\)\), "=", 
          RowBox[{
            FormBox[
              RowBox[{
                RowBox[{
                  FormBox[
                    RowBox[{\(\[Integral]\[Integral]\_A\), "||", 
                      RowBox[{
                        FormBox[
                          
                          FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                                    s\) \((s, t)\)\),
                            "TraditionalForm"],
                          "TraditionalForm"], "\[Times]", 
                        FormBox[
                          
                          FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                                    t\) \((s, t)\)\),
                            "TraditionalForm"],
                          "TraditionalForm"]}], "||"}],
                    "TraditionalForm"], \(\[DifferentialD]\((s, t)\)\)}], 
                "=", \(\[Integral]\_0\%\(2  \[Pi]\)\(\([\)\(\[Integral]\_a\%b\
\( z(t)\) \(\@\(x' \((t)\)\^2 + 
                                z' \((t)\)\^2\)\) \[DifferentialD]t\)\(]\)\) \
\[DifferentialD]s = 2  \[Pi]\)}],
              
              "TraditionalForm"], \(\[Integral]\_a\%b\( z(
                  t)\) \(\@\(x' \((t)\)\^2 + 
                      z' \((t)\)\^2\)\) \(\(\[DifferentialD]\)\(t\)\(\ \
\)\)\)}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "recordemos que la segunda coordenada del centroide de la curva \[Alpha] \
viene dada por  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta] = \(\(\[Integral]\_\(\(\ \)\(\[Alpha]\)\)\ z \
\[DifferentialD]s\)\/\(\[Integral]\_\(\(\ \)\(\[Alpha]\)\)\[DifferentialD]s\) \
= \(\[Integral]\_\(\(\ \)\(\[Alpha]\)\)\ z \[DifferentialD]s\)\/\(\[Lambda](\
\[Alpha])\)\)\)]],
  " donde \[Lambda](\[Alpha]) es la longitud de la curva \[Alpha]. Concluimos \
que ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalAAcute]rea(S) = 
        2  \[Pi]\ \[Beta]\ \(\[Lambda](\[Alpha])\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`2  \[Pi]\ \[Beta]\)]],
  " es la longitud de la circunferencia que recorre el centroide al girar la \
curva alrededor del eje X."
}], "Text"],

Cell["\<\
El siguiente resultado, aunque no est\[AAcute] directamente relacionado con \
este tema, lo incluyo aqu\[IAcute] por complitud. \
\>", "Text"],

Cell[TextData[{
  StyleBox[
  "F\[OAcute]rmula de Pappus para calcular el volumen de un s\[OAcute]lido de \
revoluci\[OAcute]n",
    FontWeight->"Bold"],
  ". El volumen de un s\[OAcute]lido de revoluci\[OAcute]n obtenido girando \
una figura plana alrededor de una recta que no la corta situada en su mismo \
plano es igual al producto del \[AAcute]rea de la figura plana por la \
longitud de la circunferencia que describe el centroide de la misma."
}], "Text"],

Cell[TextData[{
  "Vamos a probar la afirmaci\[OAcute]n anterior. Supongamos, por comodidad, \
que la figura plana est\[AAcute] contenida en el plano XZ y su frontera es \
una curva dada por ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha](t) = \((x(t), z(t))\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] t \[LessEqual] b\)]],
  ". Suponemos tambi\[EAcute]n que ",
  Cell[BoxData[
      \(TraditionalForm\`x(t) > 0\)]],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Element] \([a, b]\)\)]],
  ". Observa que estas hip\[OAcute]tesis no son restrictivas pues el caso \
general puede reducirse a \[EAcute]ste mediante un giro y una traslaci\
\[OAcute]n que son movimientos del espacio que conservan los \
vol\[UAcute]menes. Al girar la figura plana alrededor del eje Z se obtiene un \
s\[OAcute]lido de revoluci\[OAcute]n ",
  StyleBox["R",
    FontSlant->"Italic"],
  " que est\[AAcute] limitado por la superficie dada por ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma](s, t) = 
        \((\(x(t)\)\ cos\ s, \ \(z(t)\)\ sen\ s, \ z(t)\ )\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] t \[LessEqual] b\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] s \[LessEqual] 2  \[Pi]\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Aqu\[IAcute] puedes ver una figura plana ",
  StyleBox["F",
    FontSlant->"Italic"],
  " coloreada de amarillo y el s\[OAcute]lido de revoluci\[OAcute]n \
\[CapitalOmega] obtenido gir\[AAcute]ndola alrededor del eje Z."
}], "Text"],

Cell[BoxData[{
    \(\(figura = 
        ParametricPlot[{ .25 + \@\(1 - t\^2\), 
              t*ArcCos[t] \((\[Pi] - ArcCos[t])\)/4}, {t, \(-1\), 1}, 
            AxesOrigin -> {0, 0}, 
            PlotRange -> {{\(- .1\), 1.3}, {\(- .33\),  .33}}, 
            AspectRatio -> Automatic, AxesLabel -> {"\<X\>", "\<Z\>"}, 
            Ticks -> None, PlotStyle -> Thickness[ .007], 
            DisplayFunction -> Identity] /. 
          Line[x_] -> {Line[x], {Yellow, Polygon[x]}};\)\), "\n", 
    \(\(Show[figura, Graphics[Line[{{\(- .1\), 0}, {1.3, 0}}]], 
        DisplayFunction -> $DisplayFunction];\)\), "\n", 
    \(\(ParametricPlot3D[{\(( .25 + \@\(1 - t\^2\))\) 
            Cos[s], \(( .25 + \@\(1 - t\^2\))\) Sin[s], 
          t*ArcCos[t] \((\[Pi] - ArcCos[t])\)/4}, {t, \(-1\), 1}, {s, 0, 
          2  \[Pi]}, Axes -> False];\)\)}], "Input"],

Cell[TextData[{
  "El volumen de \[CapitalOmega] viene dado por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\[Integral]\(\[Integral]\[Integral]\_\[CapitalOmega]\)\),
            "TraditionalForm"], "1", \(\[DifferentialD]\((x, y, z)\)\)}], 
        TraditionalForm]]],
  ". Haciendo un  cambio de variables a coordenadas cil\[IAcute]ndricas, \
tenemos que"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            
            FormBox[\(Volumen(\[CapitalOmega]) = 
                \[Integral]\(\[Integral]\[Integral]\_\[CapitalOmega]\)\),
              "TraditionalForm"], \(\[DifferentialD]\((x, y, z)\)\)}], "=", 
          \(\[Integral]\(\[Integral]\(\[Integral]\_B \[Rho] 
                  \[DifferentialD]\((\[Rho], \[Theta], z)\)\)\)\)}], 
        TraditionalForm]]],
  "  donde"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`B = \({\((\[Rho], \[Theta], z)\) : 
            \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta], \ z)\) 
              \[Element] \ \[CapitalOmega]} = {
          \((\[Rho], \[Theta], z)\) : \ \((\[Rho], z)\) \[Element] F, \ 
          0 \[LessEqual] \[Theta] \[LessEqual] 2  \[Pi]}\)\)]]], "Text",
  TextAlignment->Center],

Cell["En consecuencia, usando el teorema de Fubini, tenemos que", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          
          FormBox[\(Volumen(\[CapitalOmega]) = 
              \[Integral]\(\[Integral]\[Integral]\_\[CapitalOmega]\)\),
            "TraditionalForm"], \(\[DifferentialD]\((x, y, z)\)\)}], "=", 
        RowBox[{
        \(\[Integral]\(\[Integral]\(\[Integral]\_B \[Rho] 
                  \[DifferentialD]\((\[Rho], \[Theta], z)\)\)\)\), "=", 
          RowBox[{
            RowBox[{\(\[Integral]\_0\%\(2  \[Pi]\)\), 
              RowBox[{
                RowBox[{"[", 
                  RowBox[{"\[Integral]", 
                    RowBox[{
                      SubscriptBox["\[Integral]", 
                        StyleBox["F",
                          FontSlant->"Italic"]], 
                      \(\[Rho] \[DifferentialD]\((\[Rho], z)\)\)}]}], "]"}], 
                \(\[DifferentialD]\[Theta]\)}]}], "=", 
            RowBox[{
              RowBox[{"2", "\[Pi]", 
                RowBox[{"\[Integral]", 
                  RowBox[{
                    SubscriptBox["\[Integral]", 
                      StyleBox["F",
                        FontSlant->"Italic"]], 
                    \(\[Rho] \[DifferentialD]\((\[Rho], z)\)\)}]}]}], "=", 
              RowBox[{
                RowBox[{"2", "\[Pi]", " ", "\[Alpha]", 
                  RowBox[{"\[Integral]", 
                    RowBox[{
                      SubscriptBox["\[Integral]", 
                        StyleBox["F",
                          FontSlant->"Italic"]], 
                      \(\[DifferentialD]\((\[Rho], z)\)\)}]}]}], "=", " ", 
                \(2  \[Pi]\ \[Alpha]\ \[CapitalAAcute]rea 
                  \((F)\)\)}]}]}]}]}], TextForm]], "Text"],

Cell[TextData[{
  "donde \[Alpha] es la abscisa del centroide de ",
  StyleBox["F.",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Hacer los ejercicios propuestos en el libro de James Stewart ",
  StyleBox["C\[AAcute]lculo Multivariable",
    FontSlant->"Italic"],
  " 4\.aa Ed., en la secci\[OAcute]n 16.7 (p\[AAcute]gina 1103), ejercicios \
5-18."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "a) Calcula el centroide de la semiesfera ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 + z\^2 = R\^2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`z \[GreaterEqual] 0\)]],
  ".\nb) Calcula la masa de un embudo delgado en forma de cono ",
  Cell[BoxData[
      \(TraditionalForm\`z = \@\(x\^\(2\ \) + y\^2\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] z \[LessEqual] 4\)]],
  ", cuya funci\[OAcute]n de densidad es ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho](x, y, z) = 10\  - z\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\((gr/cm\^2)\)\)]],
  ". "
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integral de superficie de un campo vectorial", "Section"],

Cell[TextData[{
  "Consideremos una superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S = \[Gamma](A)\)]],
  " donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](s, t)\), "=", 
          RowBox[{\((x(s, t), y(s, t), z(s, t))\), "=", 
            RowBox[{
              RowBox[{\(x(s, t)\), 
                StyleBox["i",
                  FontWeight->"Bold"]}], " ", "+", " ", 
              RowBox[{\(y(s, t)\), 
                StyleBox["j",
                  FontWeight->"Bold"]}], "+", 
              RowBox[{\(z(s, t)\), 
                StyleBox["k",
                  FontWeight->"Bold"]}]}]}]}], TraditionalForm]]],
  " y ",
  StyleBox["A",
    FontSlant->"Italic"],
  " es un subconjunto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  ". Sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{
            RowBox[{"P", \((x, y, z)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"Q", \((x, y, z)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"R", \((x, y, z)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "un campo vectorial de tres variables definido en un abierto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "que contiene a la superficie ",
  StyleBox["S",
    FontSlant->"Italic"],
  ". Recuerda que para definir la integral de ",
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          FontWeight->"Bold"], TraditionalForm]]],
  " sobre una curva lo que se hac\[IAcute]a era considerar un campo de \
vectores sobre la curva, a saber, el campo vectorial que a cada punto de la \
curva hace corresponder el vector tangente unitario en dicho punto. Ahora \
necesitamos hacer algo parecido. Necesitamos definir un campo vectorial de \
tres variables sobre la superficie ",
  StyleBox["S",
    FontSlant->"Italic"],
  ". Puesto que en un punto de una superficie hay muchos vectores tangentes \
pero hay solamente dos vectores normales unitarios opuestos entre s\[IAcute], \
parece natural elegir uno de dichos vectores en cada punto de la superficie y \
de esta forma obtenemos un campo vectorial que podremos multiplicar \
escalarmente por ",
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          FontWeight->"Bold"], TraditionalForm]]],
  " lo que nos va a llevar a la integral que queremos definir. "
}], "Text"],

Cell[TextData[{
  "Nos vemos as\[IAcute] llevados a la necesidad de elegir en cada punto de \
una superficie uno de los dos vectores unitarios normales a la superficie en \
dicho punto. Representaremos por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], TraditionalForm]]],
  " un vector normal unitario a ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Element] S\)]],
  ". El otro vector normal unitario ser\[AAcute] ",
  Cell[BoxData[
      FormBox[
        RowBox[{"-", 
          RowBox[{
            StyleBox["n",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}]}], 
        TraditionalForm]]],
  ". ",
  StyleBox["Diremos que la superficie ",
    FontWeight->"Bold"],
  StyleBox["S ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["es orientable cuando es posible definir un campo vectorial ",
    FontWeight->"Bold"],
  StyleBox["continuo",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" sobre ",
    FontWeight->"Bold"],
  StyleBox["S ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["que a cada punto de ",
    FontWeight->"Bold"],
  StyleBox["S",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" asigne uno de los vectores unitarios normales en dicho punto. \
Cuando dicho campo vectorial existe se llama una orientaci\[OAcute]n de ",
    FontWeight->"Bold"],
  StyleBox["S",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[". ",
    FontSlant->"Italic"],
  "Es claro que una superficie orientable tiene dos posibles orientaciones.",
  "\nLas superficies orientables tienen \"dos caras\" porque, intuitivamente, \
lo que hace una orientaci\[OAcute]n es definir en cada punto de la superficie \
una direcci\[OAcute]n \"hacia arriba\" que es aquella direcci\[OAcute]n en la \
que apunta el vector normal y la direcci\[OAcute]n opuesta define una direcci\
\[OAcute]n \"hacia abajo\". Por tanto podemos distinguir una cara de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " \"hacia arriba\" y otra cara de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " \"hacia abajo\". La mayor\[IAcute]a de las superficies usuales son \
orientables pero hay algunas superficies que no lo son y suelen llamarse \
\"superficies de una sola cara\". La m\[AAcute]s conocida es la llamada \
\"banda de Moebius\". Aqu\[IAcute] la tienes."
}], "Text"],

Cell[BoxData[{
    \(\(moebius[r_, \[Theta]_] = {2\ Cos[\[Theta]] + \ r\ Cos[\[Theta]/2], 
          2  Sin[\[Theta]] + \ r\ Cos[\[Theta]/2], 
          r\ Sin[\[Theta]/2]};\)\ \), "\n", 
    \(\(bandamoebius = 
        ParametricPlot3D[{2\ Cos[\[Theta]] + \ r\ Cos[\[Theta]/2], 
            2  Sin[\[Theta]] + \ r\ Cos[\[Theta]/2], r\ Sin[\[Theta]/2], 
            EdgeForm[Hue[0], 
              AbsoluteThickness[1.5]]}, {r, \(- .5\),  .5}, {\[Theta], 0, 
            2  \[Pi]}, PlotPoints -> {3, 40}, 
          ViewPoint -> {3.223, \ \(-0.335\), \ 0.975}, Boxed -> False, 
          Axes -> False];\)\)}], "Input"],

Cell[BoxData[
    \(\(moebnormal[r_, \[Theta]_] = 
        Module[{u, v}, 
          Cross[D[moebius[u, v], u], D[moebius[u, v], v]]/
              norma[Cross[D[moebius[u, v], u], D[moebius[u, v], v]]] /. {u -> 
                r, v -> \[Theta]}];\)\)], "Input"],

Cell[BoxData[{
    \(\(vectoresnormales = 
        Graphics3D[
          Table[vector3D[moebius[0. , \[Theta]], moebnormal[0. , \[Theta]], 
              Yellow,  .01], {\[Theta], 0, 2  \[Pi], 
              N[2  \[Pi]]/20}]];\)\), "\n", 
    \(\(fig = Show[bandamoebius, vectoresnormales];\)\)}], "Input"],

Cell[BoxData[{
    \(SpinShow[fig]\), "\n", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[TextData[{
  "La aplicaci\[OAcute]n que hemos definido ",
  StyleBox["no es continua sobre la superficie",
    FontSlant->"Italic"],
  ": hay puntos muy pr\[OAcute]ximos en la superficie cuyos vectores normales \
asociados est\[AAcute]n muy alejados, de hecho su distancia es casi igual a \
2. Podemos comprobarlo."
}], "Text"],

Cell[BoxData[
    \(\(Table[{moebius[0. , \[Theta]], 
            moebius[0. , \[Theta] - 2  \[Pi] +  .01], 
            norma[moebius[0. , \[Theta]] - 
                moebius[0. , \[Theta] - 2  \[Pi] +  .01]], 
            moebnormal[0. , \[Theta]], moebnormal[0. , \[Theta] - 2  \[Pi]], 
            norma[moebnormal[0. , \[Theta]] - 
                moebnormal[0. , \[Theta] - 2  \[Pi]]]}, {\[Theta], 
            2  \[Pi] -  .01, 2  \[Pi],  .01/5}] // Chop\) // 
      TableForm\)], "Input"],

Cell[TextData[{
  "Se dice que la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S = \[Gamma](A)\)]],
  " es ",
  StyleBox["simple",
    FontWeight->"Bold"],
  " cuando la funci\[OAcute]n \[Gamma] es inyectiva en ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ". Observa que la banda de Moebius no es una superficie simple."
}], "Text"],

Cell[BoxData[
    \(moebius[r, 0] == moebius[\(-r\), 2  \[Pi]]\)], "Input"],

Cell["Las siguientes gr\[AAcute]ficas ayudan a comprender lo que pasa.", 
  "Text"],

Cell[BoxData[{
    \(\(p1 = 
        ParametricPlot3D[{2\ Cos[\[Theta]] + \ r\ Cos[\[Theta]/2], 
            2  Sin[\[Theta]] + \ r\ Cos[\[Theta]/2], r\ Sin[\[Theta]/2], 
            EdgeForm[Hue[0], AbsoluteThickness[1.5]]}, {r, 
            0,  .5}, {\[Theta], 0, 2  \[Pi]}, PlotPoints -> {3, 40}, 
          ViewPoint -> {3.223, \ \(-0.335\), \ 0.975}, Boxed -> False, 
          Axes -> False];\)\), "\n", 
    \(\(Print["\<Mitad de una banda de Moebius para \
0\[LessEqual]r\[LessEqual].5\>"];\)\), "\n", 
    \(\(p2 = 
        ParametricPlot3D[{2\ Cos[\[Theta]] + \ r\ Cos[\[Theta]/2], 
            2  Sin[\[Theta]] + \ r\ Cos[\[Theta]/2], r\ Sin[\[Theta]/2], 
            EdgeForm[Hue[ .65], AbsoluteThickness[1.5]]}, {r, \(- .5\), 
            0}, {\[Theta], 0, 2  \[Pi]}, PlotPoints -> {3, 40}, 
          ViewPoint -> {3.223, \ \(-0.335\), \ 0.975}, Boxed -> False, 
          Axes -> False];\)\), "\n", 
    \(\(Print["\<Mitad de una banda de Moebius para -.5\[LessEqual]r\
\[LessEqual]0\>"];\)\), "\n", 
    \(\(Show[p1, p2];\)\), "\n", 
    \(\(Print["\<Banda de Moebius completa para \
-.5\[LessEqual]r\[LessEqual].5\nObserva c\[OAcute]mo las curvas fronteras de \
las dos mitades anteriores coinciden.\>"];\)\)}], "Input"],

Cell[TextData[{
  "Supuesto que ",
  StyleBox["S",
    FontSlant->"Italic"],
  " es una superficie suave y simple, se verifica que la funci\[OAcute]n \
definida para todo ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Element] S\)]],
  " por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["n",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
        RowBox[{
          FormBox[
            FractionBox[
              RowBox[{
                FormBox[
                  
                  FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\) \((s, 
                        t)\)\),
                    "TraditionalForm"],
                  "TraditionalForm"], "\[Times]", 
                FormBox[
                  
                  FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\) \((s, 
                        t)\)\),
                    "TraditionalForm"],
                  "TraditionalForm"]}], 
              RowBox[{"||", 
                RowBox[{
                  FormBox[
                    
                    FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\) \((s, 
                          t)\)\),
                      "TraditionalForm"],
                    "TraditionalForm"], "\[Times]", 
                  FormBox[
                    
                    FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\) \((s, 
                          t)\)\),
                      "TraditionalForm"],
                    "TraditionalForm"]}], "||"}]],
            "TraditionalForm"], "donde", 
          FormBox[\(\[Gamma](s, t) = \((x, y, z)\) \[Element] S\),
            "TraditionalForm"], "                         ", \((2)\)}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "es continua sobre ",
  StyleBox["S",
    FontSlant->"Italic"],
  " por lo que la superficie ",
  StyleBox["S",
    FontSlant->"Italic"],
  " es orientable. La orientaci\[OAcute]n definida por (2) se dice que est\
\[AAcute] ",
  StyleBox["inducida",
    FontWeight->"Bold"],
  " por la parametrizaci\[OAcute]n \[Gamma]. En particular, si  la superficie \
es la gr\[AAcute]fica de una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`S = {\((x, y, h(x, y))\) \[Element] 
            \(\(\[DoubleStruckCapitalR]\^2\) : \ \((x, y)\) \[Element] A\)}
          \)]],
  " donde  ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \ \[DoubleStruckCapitalR]\^2\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`h : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " es un campo escalar de dos variables, entonces dicha superficie tiene \
como ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](x, y) = \((x, y, h(x, y))\)\)]],
  " (y es simple y suave) por lo que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\[PartialD]\ \[Gamma]\/\[PartialD]\ x\) \((x, y)\) = 
        \((1, 0, \(\[PartialD]\ h\/\[PartialD]\ x\) \((x, y)\))\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\[PartialD]\ \[Gamma]\/\[PartialD]\ y\) \((x, y)\) = 
        \((0, 1, \(\[PartialD]\ h\/\[PartialD]\ y\) \((x, y)\))\)\)]],
  ". En este caso tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{
            RowBox[{
              StyleBox["n",
                FontWeight->"Bold"], "(", \(x, y, h(x, y)\), ")"}], "=", 
            FormBox[
              RowBox[{
                FractionBox[
                  RowBox[{
                    FormBox[
                      
                      FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                                x\) \((x, y)\)\),
                        "TraditionalForm"],
                      "TraditionalForm"], "\[Times]", 
                    FormBox[
                      
                      FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                                y\) \((x, y)\)\),
                        "TraditionalForm"],
                      "TraditionalForm"]}], 
                  RowBox[{"||", 
                    RowBox[{
                      FormBox[
                        
                        FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                                  x\) \((x, y)\)\),
                          "TraditionalForm"],
                        "TraditionalForm"], "\[Times]", 
                      FormBox[
                        
                        FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                                  y\) \((x, y)\)\),
                          "TraditionalForm"],
                        "TraditionalForm"]}], "||"}]], "="}],
              "TraditionalForm"]}],
          "TraditionalForm"], 
        FractionBox[
          RowBox[{
            RowBox[{"-", 
              FormBox[
                RowBox[{
                  RowBox[{\(\[PartialD]\ h\/\[PartialD]\ x\), \((x, y)\), 
                    StyleBox["i",
                      FontWeight->"Bold"]}], " ", "-"}],
                "TraditionalForm"]}], 
            FormBox[
              RowBox[{
                RowBox[{\(\[PartialD]\ h\/\[PartialD]\ y\), \((x, y)\), 
                  StyleBox["j",
                    FontWeight->"Bold"]}], " ", "+", " ", 
                StyleBox["k",
                  FontWeight->"Bold"]}],
              "TraditionalForm"]}], 
          SqrtBox[
            
            FormBox[\(\(\((\(\[PartialD]\ h\/\[PartialD]\ x\) \((x, 
                          y)\))\)\^2\)\(+\)\(\ \)\(\((\(\[PartialD]\ 
                              h\/\[PartialD]\ y\) \((x, 
                          y)\))\)\^2\)\(+\)\(1\)\(\ \ \)\),
              "TraditionalForm"]]], "           ", \((3)\)}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Cuando la superficie est\[AAcute] ",
  "definida impl\[IAcute]citamente",
  " por una ecuaci\[OAcute]n, es decir, se trata de una superficie de la \
forma ",
  Cell[BoxData[
      \(TraditionalForm\`S = {\((x, y, 
                z)\) \[Element] \(\(\[DoubleStruckCapitalR]\^3\) : 
                g(x, y, z)\) = 0}\)]],
  " donde ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es un campo escalar de tres variables cuyo gradiente no se anula nunca en \
",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ". Entonces una orientaci\[OAcute]n en ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " viene dada por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          RowBox[{"(", 
            StyleBox[\(x, y, z\),
              FontSlant->"Italic"], ")"}]}], "=", 
        FractionBox[
          RowBox[{
            RowBox[{"\[Del]", 
              StyleBox["g",
                FontSlant->"Italic"]}], 
            StyleBox[\((x, y, z)\),
              FontSlant->"Italic"]}], 
          RowBox[{"||", 
            RowBox[{
              RowBox[{"\[Del]", 
                StyleBox["g",
                  FontSlant->"Italic"]}], 
              StyleBox[\((x, y, z)\),
                FontSlant->"Italic"]}], "||"}]]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La integral de un campo vectorial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{
            RowBox[{"P", \((x, y, z)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"Q", \((x, y, z)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"R", \((x, y, z)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " sobre una superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " que suponemos simple y suave, se define por"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{"\[Integral]", 
                RowBox[{\(\[Integral]\_S\), 
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold"], 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    RowBox[{"\[DifferentialD]", 
                      StyleBox["S",
                        FontWeight->"Bold"]}]}]}]}], "=", 
              RowBox[{"\[Integral]", 
                RowBox[{\(\[Integral]\_S\), 
                  RowBox[{
                    RowBox[{
                      StyleBox["F",
                        FontWeight->"Bold"], "(", \(\[Gamma](s, t)\), ")"}], 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["n",
                        FontWeight->"Bold"], "(", \(\[Gamma](s, t)\), 
                      ")"}]}]}]}]}],
            "TraditionalForm"], \(\[DifferentialD]S\)}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            FontWeight->"Bold"], "(", \(\[Gamma](s, t)\), ")"}], 
        TraditionalForm]]],
  " viene dado por la igualdad (2) en el caso de que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(S\)\(=\)\(\[Gamma](A)\)\(\ \)\)\)]],
  "o por la igualdad (3) en el caso de que ",
  StyleBox["S",
    FontSlant->"Italic"],
  " sea la gr\[AAcute]fica de una funci\[OAcute]n ",
  StyleBox["h",
    FontSlant->"Italic"],
  ". Es decir, la integral de superficie de un campo vectorial sobre una \
superficie ",
  StyleBox["S",
    FontSlant->"Italic"],
  " es igual a la integral de superficie del campo escalar ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(\[Gamma](s, t)\), ")"}], 
          StyleBox[".",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox["n",
              FontWeight->"Bold"], "(", \(\[Gamma](s, t)\), ")"}]}], 
        TraditionalForm]]],
  " sobre ",
  StyleBox["S",
    FontSlant->"Italic"],
  ". Teniendo en cuenta la definici\[OAcute]n de integral de superficie de un \
campo escalar,  cuando ",
  Cell[BoxData[
      \(TraditionalForm\`S = \[Gamma](A)\)]],
  " tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{
            RowBox[{"\[Integral]", 
              RowBox[{\(\[Integral]\_S\), 
                RowBox[{
                  StyleBox["F",
                    FontWeight->"Bold"], 
                  StyleBox[".",
                    FontWeight->"Bold"], 
                  RowBox[{"\[DifferentialD]", 
                    StyleBox["S",
                      FontWeight->"Bold"]}]}]}]}], "=", 
            RowBox[{"\[Integral]", 
              RowBox[{\(\[Integral]\_A\), 
                RowBox[{
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold"], "(", \(\[Gamma](s, t)\), ")"}], 
                  StyleBox[".",
                    FontWeight->"Bold"], 
                  RowBox[{
                    StyleBox["(",
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[
                        
                        FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                                  s\) \((s, t)\)\),
                          "TraditionalForm"],
                        "TraditionalForm"], "\[Times]", 
                      FormBox[
                        
                        FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ 
                                  t\) \((s, t)\)\),
                          "TraditionalForm"],
                        "TraditionalForm"]}], ")"}]}]}]}]}],
          "TraditionalForm"], \(\[DifferentialD]\((s, t)\)\)}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y cuando ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " es la gr\[AAcute]fica de una funci\[OAcute]n ",
  StyleBox["h",
    FontSlant->"Italic"],
  " tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{"\[Integral]", 
                RowBox[{\(\[Integral]\_S\), 
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold"], 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    RowBox[{"\[DifferentialD]", 
                      StyleBox["S",
                        FontWeight->"Bold"]}]}]}]}], "=", 
              RowBox[{"\[Integral]", 
                RowBox[{\(\[Integral]\_A\), 
                  RowBox[{\(F(x, y, h(x, y))\), 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    RowBox[{"(", 
                      RowBox[{
                        
                        RowBox[{\(-\(\[PartialD]h\/\[PartialD]\ x\)\), \((x, 
                            y)\), 
                          StyleBox["i",
                            FontWeight->"Bold"]}], 
                        StyleBox["-",
                          FontWeight->"Plain"], 
                        
                        RowBox[{\(\[PartialD]h\/\[PartialD]\ y\), \((x, y)\), 
                          
                          StyleBox["j",
                            FontWeight->"Bold"]}], "+", 
                        StyleBox["k",
                          FontWeight->"Bold"]}], ")"}]}]}]}]}],
            "TraditionalForm"], \(\[DifferentialD]\((x, y)\)\)}], 
        "=", \(\[Integral]\(\[Integral]\_A\((\(-\(P(x, y, 
                        h(x, y))\)\) \(\[PartialD]\ h\/\[PartialD]\ x\) \((x, 
                      y)\) - \(Q(x, y, 
                      h(x, y))\) \(\[PartialD]\ h\/\[PartialD]\ y\) \((x, 
                      y)\) + R(x, y, h(x, y)))\) \[DifferentialD]\((x, 
                  y)\)\)\)}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En f\[IAcute]sica suele llamarse a la integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          RowBox[{\(\[Integral]\_S\), " ", 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox[".",
                FontWeight->"Bold"], 
              RowBox[{"\[DifferentialD]", 
                StyleBox["S",
                  FontWeight->"Bold"]}]}]}]}], TraditionalForm]]],
  " ",
  StyleBox["flujo",
    FontWeight->"Bold"],
  " de ",
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          FontWeight->"Bold"], TraditionalForm]]],
  " a trav\[EAcute]s de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Con frecuencia es preciso calcular integrales sobre superficies que tienen \
aristas y no son suaves ni orientables en el sentido que acabamos de definir \
pero que son \"suaves y orientables a trozos\" esto es, que se obtienen \
\"pegando\" varias superficies suaves y orientables; por ejemplo, la \
superficie formada por las caras de un poliedro. En tal caso, ",
  StyleBox["la integral de un campo vectorial sobre una superficie suave y \
orientable a trozos se define como la suma de las integrales sobre cada una \
de las superficies suaves y orientables que la forman",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[TextData[{
  "Para una ",
  StyleBox["superficie cerrada",
    FontWeight->"Bold"],
  ", esto es una superficie que es la frontera de un dominio acotado en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ", se conviene que la ",
  StyleBox["orientaci\[OAcute]n positiva",
    FontWeight->"Bold"],
  " es aquella en la que los vectores normales apuntan siempre hacia el ",
  StyleBox["exterior de la superficie",
    FontWeight->"Bold"],
  ". Si una superficie cerrada viene dada por una parametrizaci\[OAcute]n, \
puede ocurrir que la orientaci\[OAcute]n inducida por dicha parametrizaci\
\[OAcute]n no sea la orientaci\[OAcute]n positiva. Cuando esto ocurre basta \
intercambiar las variables para que la orientaci\[OAcute]n inducida sea la \
orientaci\[OAcute]n positiva."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejemplos", "Subsection"],

Cell[TextData[{
  StyleBox["Flujo de un campo vectorial a trav\[EAcute]s de una superficie",
    FontWeight->"Bold"],
  " \nConsideremos que el campo  ",
  Cell[BoxData[
      FormBox[
        StyleBox["v",
          FontWeight->"Bold"], TraditionalForm]]],
  " es el campo de velocidades de un fluido que se mueve en una \
regi\[OAcute]n del espacio, esto es,  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], TraditionalForm]]],
  " es el vector velocidad, por ejemplo en m/s, del fluido en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  ". Suponemos, por comodidad, que la velocidad no depende del tiempo sino \
solamente de las coordenadas espaciales del punto, es decir, que se trata de \
un fluido estacionario (en el caso general en que la velocidad \
tambi\[EAcute]n depende del tiempo, las consideraciones que siguen permanecen \
v\[AAcute]lidas en ",
  StyleBox["cada instante",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  "). Consideremos una superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " orientada por un campo de vectores normales unitarios ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], TraditionalForm]]],
  ". Suponemos que dicha superficie no impide el paso del fluido el cual \
puede fluir libremente a trav\[EAcute]s de ella. Queremos calcular el volumen \
total de fluido que atraviesa la superficie por unidad de tiempo, es decir, \
el flujo (volum\[EAcute]trico) del fluido a trav\[EAcute]s de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ". Es evidente que dicho flujo depende de la \"posici\[OAcute]n de la \
superficie\" respecto al campo de velocidades del fluido, el flujo ser\
\[AAcute] m\[AAcute]ximo cuando el campo sea normal a la superficie y ser\
\[AAcute] nulo cuando el campo sea tangente a la superficie. Es por ello por \
lo que precisamos tener una orientaci\[OAcute]n en la superficie pues de esta \
forma podemos precisar la \"posici\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  "\" respecto al campo de velocidades.\nConsideremos el caso m\[AAcute]s \
simple en que la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " es un paralelogramo plano engendrado por los vectores ",
  StyleBox["a",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " y ",
  Cell[BoxData[
      FormBox[
        StyleBox["b",
          FontWeight->"Bold"], TraditionalForm]]],
  " y el campo de velocidades, ",
  StyleBox["v",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " , es constante. En este caso tan sencillo, el flujo a trav\[EAcute]s de \
",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " es igual al volumen (con signo) del paralelep\[IAcute]pedo engendrado por \
los vectores ",
  StyleBox["a",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontSlant->"Italic"],
  StyleBox["b",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontSlant->"Italic"],
  StyleBox["v",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " que sabemos es igual al producto mixto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(v . \((a\[Times]b)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "; pues el fluido que en un instante dado se encuentra en el paralelogramo, \
al cabo de un segundo se encontrar\[AAcute] en otro paralelogramo trasladado \
del primero mediante el vector ",
  Cell[BoxData[
      FormBox[
        StyleBox["v",
          FontWeight->"Bold"], TraditionalForm]]],
  ". Recuerda que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(a\[Times]b\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es un vector normal a ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " cuya norma es igual al \[AAcute]rea de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ". Supuesto que usamos el metro como unidad de longitudes, el \
n\[UAcute]mero ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(v . \((a\[Times]b)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se expresa en metros c\[UAcute]bicos por segundo. El signo de dicho n\
\[UAcute]mero indica si el flujo es saliente (signo positivo cuando el vector \
",
  Cell[BoxData[
      FormBox[Cell[TextData[Cell[BoxData[
            FormBox[
              StyleBox["v",
                FontWeight->"Bold"], TraditionalForm]]]]], 
        TraditionalForm]]],
  " y el vector ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(a\[Times]b\),
          FontWeight->"Bold"], TraditionalForm]]],
  " forman un \[AAcute]ngulo agudo, esto es \"apuntan en la misma direcci\
\[OAcute]n\") o entrante (signo negativo cuando el vector ",
  Cell[BoxData[
      FormBox[Cell[TextData[Cell[BoxData[
            FormBox[
              StyleBox["v",
                FontWeight->"Bold"], TraditionalForm]]]]], 
        TraditionalForm]]],
  " y el vector ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(a\[Times]b\),
          FontWeight->"Bold"], TraditionalForm]]],
  " forman un \[AAcute]ngulo mayor de 90 grados, esto es \"apuntan en \
direcciones opuestas\").   \nVolviendo al caso general, el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], TraditionalForm]]],
  " puede descomponerse en cada punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " de la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " como suma de dos vectores ortogonales de los cuales uno de ellos est\
\[AAcute] en el plano tangente a ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " en el punto considerado y el otro se obtiene como la proyecci\[OAcute]n \
ortogonal del vector sobre el vector normal unitario ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], TraditionalForm]]],
  ", es decir, es el vector ",
  Cell[BoxData[
      FormBox[Cell[TextData[Cell[BoxData[
            FormBox[
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      StyleBox["v",
                        FontWeight->"Bold"], "(", \(x, y, z\), ")"}], 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["n",
                        FontWeight->"Bold"], 
                      StyleBox["(",
                        FontWeight->"Plain"], 
                      StyleBox[\(x, y, z\),
                        FontWeight->"Plain"], 
                      StyleBox[")",
                        FontWeight->"Plain"]}]}], 
                  StyleBox[")",
                    FontWeight->"Plain"]}], 
                StyleBox[" ",
                  FontWeight->"Plain"], 
                RowBox[{
                  StyleBox["n",
                    FontWeight->"Bold"], 
                  StyleBox["(",
                    FontWeight->"Plain"], 
                  StyleBox[\(x, y, z\),
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}]}], TraditionalForm]]]]], 
        TraditionalForm]]],
  ". La componente tangente a ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " no ",
  StyleBox["atraviesa",
    FontSlant->"Italic"],
  " dicha superficie (lo que hace es establecer una ",
  StyleBox["circulaci\[OAcute]n",
    FontSlant->"Italic"],
  " del fluido ",
  StyleBox["sobre",
    FontSlant->"Italic"],
  " la misma) y su contribuci\[OAcute]n al flujo es nula. Por ello, para \
calcular el flujo solamente se considera la componente del campo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], TraditionalForm]]],
  " que es normal a la superficie, esto es, el vector  ",
  Cell[BoxData[
      FormBox[Cell[TextData[Cell[BoxData[
            FormBox[
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      StyleBox["v",
                        FontWeight->"Bold"], "(", \(x, y, z\), ")"}], 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["n",
                        FontWeight->"Bold"], 
                      StyleBox["(",
                        FontWeight->"Plain"], 
                      StyleBox[\(x, y, z\),
                        FontWeight->"Plain"], 
                      StyleBox[")",
                        FontWeight->"Plain"]}]}], 
                  StyleBox[")",
                    FontWeight->"Plain"]}], 
                StyleBox[" ",
                  FontWeight->"Plain"], 
                RowBox[{
                  StyleBox["n",
                    FontWeight->"Bold"], 
                  StyleBox["(",
                    FontWeight->"Plain"], 
                  StyleBox[\(x, y, z\),
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}]}], TraditionalForm]]]]], 
        TraditionalForm]]],
  ". Ya puedes suponer lo que sigue: dividimos la superficie en \
peque\[NTilde]os parches y aproximamos el \[AAcute]rea de cada parche como lo \
hemos hecho al definir la integral de superficie y en cada uno de esos \
parches aproximamos el flujo por el volumen de un paralelep\[IAcute]pedo \
engendrado por los vectores tangentes a la superficie en un punto del parche \
y el vector  ",
  Cell[BoxData[
      FormBox[Cell[TextData[Cell[BoxData[
            FormBox[
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      StyleBox["v",
                        FontWeight->"Bold"], "(", \(x, y, z\), ")"}], 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["n",
                        FontWeight->"Bold"], 
                      StyleBox["(",
                        FontWeight->"Plain"], 
                      StyleBox[\(x, y, z\),
                        FontWeight->"Plain"], 
                      StyleBox[")",
                        FontWeight->"Plain"]}]}], 
                  StyleBox[")",
                    FontWeight->"Plain"]}], 
                StyleBox[" ",
                  FontWeight->"Plain"], 
                RowBox[{
                  StyleBox["n",
                    FontWeight->"Bold"], 
                  StyleBox["(",
                    FontWeight->"Plain"], 
                  StyleBox[\(x, y, z\),
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}]}], TraditionalForm]]]]], 
        TraditionalForm]]],
  "calculado en ese punto; hacemos la correspondiente suma y obtenemos una \
aproximaci\[OAcute]n del flujo a trav\[EAcute]s de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ". Estas aproximaciones convergen a la integral de sperficie del campo  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], TraditionalForm]]],
  " sobre ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ". Por tanto, el flujo a trav\[EAcute]s de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " viene dado por ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          RowBox[{\(\[Integral]\_S\), 
            RowBox[{
              StyleBox["v",
                FontWeight->"Bold"], 
              StyleBox[".",
                FontWeight->"Bold"], 
              RowBox[{"\[DifferentialD]", 
                StyleBox["S",
                  FontWeight->"Bold"]}]}]}]}], TraditionalForm]]],
  ".\nLas consideraciones anteriores tambi\[EAcute]n sirven para justificar \
que el flujo de masa a trav\[EAcute]s de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " viene dado por ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          RowBox[{\(\[Integral]\_S\), 
            RowBox[{"\[Rho]", " ", 
              RowBox[{
                StyleBox["v",
                  FontWeight->"Bold"], 
                StyleBox[".",
                  FontWeight->"Bold"], 
                RowBox[{"\[DifferentialD]", 
                  StyleBox["S",
                    FontWeight->"Bold"]}]}]}]}]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho](x, y, z)\)]],
  " es la funci\[OAcute]n de densidad del fluido.\nEl flujo de un campo \
vectorial a trav\[EAcute]s de una superficie tiene gran importancia en el \
estudio de campos el\[EAcute]ctricos y campos magn\[EAcute]ticos. Si ",
  Cell[BoxData[
      FormBox[
        StyleBox["E",
          FontWeight->"Bold"], TraditionalForm]]],
  " es un campo el\[EAcute]ctrico, la integral de superficie ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          RowBox[{\(\[Integral]\_S\), 
            RowBox[{
              StyleBox["E",
                FontWeight->"Bold"], 
              StyleBox[".",
                FontWeight->"Bold"], 
              RowBox[{"\[DifferentialD]", 
                StyleBox["S",
                  FontWeight->"Bold"]}]}]}]}], TraditionalForm]]],
  " se llama flujo el\[EAcute]ctrico de ",
  Cell[BoxData[
      FormBox[
        StyleBox["E",
          FontWeight->"Bold"], TraditionalForm]]],
  " a trav\[EAcute]s de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ". La ley de Gauss establece que la carga el\[EAcute]ctrica neta que hay en \
el interior de una superficie cerrada viene dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Q", "=", 
          RowBox[{\(\[Epsilon]\_0\), 
            RowBox[{"\[Integral]", 
              RowBox[{\(\[Integral]\_S\), 
                RowBox[{
                  StyleBox["E",
                    FontWeight->"Bold"], 
                  StyleBox[".",
                    FontWeight->"Bold"], 
                  RowBox[{"\[DifferentialD]", 
                    StyleBox["S",
                      FontWeight->"Bold"]}]}]}]}]}]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Hacer los ejercicios propuestos en el libro de James Stewart ",
  StyleBox["C\[AAcute]lculo Multivariable",
    FontSlant->"Italic"],
  " 4\.aa Ed., en la secci\[OAcute]n 16.7 (p\[AAcute]gina 1103), ejercicios \
19-28."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Superficies. Integrales de superficie"], "Header"]}, {
    Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Superficies. Integrales de superficie"], "Header"]}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.32.1"->{
    Cell[2218, 70, 85, 2, 70, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"],
    Cell[2306, 74, 86, 2, 70, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"]},
  "S5.29.1"->{
    Cell[4073, 114, 89, 2, 70, "Input",
      InitializationCell->True,
      CellTags->"S5.29.1"]},
  "S5.30.1"->{
    Cell[13344, 387, 65, 1, 71, "Input",
      CellTags->"S5.30.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.32.1", 138274, 3833},
  {"S5.29.1", 138488, 3840},
  {"S5.30.1", 138604, 3844}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 54, 0, 99, "Title"],
Cell[1811, 53, 164, 5, 102, "Author"],

Cell[CellGroupData[{
Cell[2000, 62, 41, 0, 93, "Section"],
Cell[2044, 64, 171, 4, 123, "Input",
  InitializationCell->True],
Cell[2218, 70, 85, 2, 70, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[2306, 74, 86, 2, 70, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[2395, 78, 692, 14, 210, "Input",
  InitializationCell->True],
Cell[3090, 94, 980, 18, 306, "Input",
  InitializationCell->True],
Cell[4073, 114, 89, 2, 70, "Input",
  InitializationCell->True,
  CellTags->"S5.29.1"]
}, Closed]],

Cell[CellGroupData[{
Cell[4199, 121, 123, 4, 61, "Section"],
Cell[4325, 127, 605, 15, 106, "Text"],
Cell[4933, 144, 394, 11, 41, "Text"],
Cell[5330, 157, 263, 8, 41, "Text"],
Cell[5596, 167, 281, 9, 42, "Text"],
Cell[5880, 178, 209, 7, 41, "Text"],
Cell[6092, 187, 125, 5, 41, "Text"],
Cell[6220, 194, 1180, 32, 120, "Text"],
Cell[7403, 228, 539, 14, 35, "Text"],
Cell[7945, 244, 204, 7, 41, "Text"],
Cell[8152, 253, 934, 31, 94, "Text"],
Cell[9089, 286, 1048, 24, 207, "Text"],
Cell[10140, 312, 169, 3, 99, "Input"],
Cell[10312, 317, 233, 5, 98, "Input"],
Cell[10548, 324, 115, 3, 41, "Text"],
Cell[10666, 329, 221, 3, 98, "Input"],
Cell[10890, 334, 1607, 29, 249, "Text"],
Cell[12500, 365, 130, 3, 73, "Input"],
Cell[12633, 370, 445, 8, 67, "Text"],
Cell[13081, 380, 260, 5, 67, "Text"],
Cell[13344, 387, 65, 1, 71, "Input",
  CellTags->"S5.30.1"],
Cell[13412, 390, 363, 7, 124, "Input"],
Cell[13778, 399, 264, 5, 153, "Input"],

Cell[CellGroupData[{
Cell[14067, 408, 31, 0, 68, "Exercise"],
Cell[14101, 410, 594, 13, 119, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14732, 428, 66, 0, 78, "Subsection"],
Cell[14801, 430, 1535, 47, 157, "Text"],
Cell[16339, 479, 321, 11, 41, "Text"],
Cell[16663, 492, 539, 14, 35, "Text"],
Cell[17205, 508, 914, 28, 93, "Text"],
Cell[18122, 538, 3721, 90, 58, "Text"],
Cell[21846, 630, 3775, 92, 58, "Text"],
Cell[25624, 724, 943, 29, 119, "Text"],
Cell[26570, 755, 1375, 35, 58, "Text"],
Cell[27948, 792, 3304, 101, 250, "Text"],
Cell[31255, 895, 194, 3, 35, "Text"],
Cell[31452, 900, 2635, 69, 267, "Text"],
Cell[34090, 971, 73, 0, 41, "Text"],
Cell[34166, 973, 1326, 27, 410, "Input"],
Cell[35495, 1002, 375, 7, 150, "Input"],
Cell[35873, 1011, 449, 8, 176, "Input"],
Cell[36325, 1021, 505, 8, 202, "Input"],
Cell[36833, 1031, 602, 10, 228, "Input"],
Cell[37438, 1043, 82, 1, 72, "Input"],
Cell[37523, 1046, 1069, 33, 119, "Text"],

Cell[CellGroupData[{
Cell[38617, 1083, 31, 0, 68, "Exercise"],
Cell[38651, 1085, 1756, 54, 237, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40468, 1146, 110, 3, 93, "Section"],
Cell[40581, 1151, 1383, 38, 119, "Text"],
Cell[41967, 1191, 490, 16, 67, "Text"],
Cell[42460, 1209, 4026, 102, 81, "Text"],
Cell[46489, 1313, 94, 2, 41, "Text"],
Cell[46586, 1317, 1444, 37, 77, "Text"],
Cell[48033, 1356, 1116, 29, 145, "Text"],
Cell[49152, 1387, 679, 19, 58, "Text"],
Cell[49834, 1408, 2221, 50, 293, "Text"],
Cell[52058, 1460, 2794, 53, 956, "Input"],
Cell[54855, 1515, 71, 0, 41, "Text"],
Cell[54929, 1517, 2403, 60, 77, "Text"],
Cell[57335, 1579, 968, 26, 73, "Text"],
Cell[58306, 1607, 973, 24, 60, "Text"],
Cell[59282, 1633, 1072, 28, 102, "Text"],
Cell[60357, 1663, 1312, 29, 72, "Text"],

Cell[CellGroupData[{
Cell[61694, 1696, 31, 0, 68, "Exercise"],
Cell[61728, 1698, 1184, 35, 234, "ExerciseText"],
Cell[62915, 1735, 305, 10, 41, "Text"],
Cell[63223, 1747, 1933, 59, 120, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[65193, 1811, 64, 0, 78, "Subsection"],
Cell[65260, 1813, 1678, 51, 119, "Text"],
Cell[66941, 1866, 2473, 63, 150, "Text"],
Cell[69417, 1931, 897, 26, 73, "Text"],
Cell[70317, 1959, 978, 26, 60, "Text"],
Cell[71298, 1987, 549, 15, 67, "Text"],
Cell[71850, 2004, 457, 9, 72, "Text"],
Cell[72310, 2015, 947, 21, 171, "Text"],
Cell[73260, 2038, 203, 4, 67, "Text"],
Cell[73466, 2044, 1272, 36, 93, "Text"],

Cell[CellGroupData[{
Cell[74763, 2084, 389, 8, 168, "Input"],
Cell[75155, 2094, 79, 1, 87, "Output"]
}, Open  ]],
Cell[75249, 2098, 962, 20, 119, "Text"],

Cell[CellGroupData[{
Cell[76236, 2122, 497, 9, 125, "Input"],
Cell[76736, 2133, 79, 1, 87, "Output"]
}, Open  ]],
Cell[76830, 2137, 1252, 36, 119, "Text"],
Cell[78085, 2175, 729, 16, 60, "Text"],
Cell[78817, 2193, 27, 0, 41, "Text"],
Cell[78847, 2195, 1650, 34, 187, "Text"],
Cell[80500, 2231, 103, 3, 41, "Text"],
Cell[80606, 2236, 430, 8, 57, "Text"],
Cell[81039, 2246, 127, 5, 41, "Text"],

Cell[CellGroupData[{
Cell[81191, 2255, 920, 18, 280, "Input"],
Cell[82114, 2275, 38, 1, 71, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[82201, 2282, 30, 0, 78, "Subsection"],
Cell[82234, 2284, 1157, 36, 157, "Text"],
Cell[83394, 2322, 533, 10, 71, "Text"],
Cell[83930, 2334, 210, 5, 41, "Text"],
Cell[84143, 2341, 1712, 42, 273, "Text"],
Cell[85858, 2385, 166, 3, 41, "Text"],
Cell[86027, 2390, 544, 9, 203, "Input"],
Cell[86574, 2401, 229, 3, 131, "Input"],
Cell[86806, 2406, 143, 5, 41, "Text"],
Cell[86952, 2413, 1482, 34, 61, "Text"],
Cell[88437, 2449, 786, 18, 110, "Text"],
Cell[89226, 2469, 152, 3, 41, "Text"],
Cell[89381, 2474, 463, 9, 93, "Text"],
Cell[89847, 2485, 1307, 34, 145, "Text"],
Cell[91157, 2521, 251, 6, 41, "Text"],
Cell[91411, 2529, 855, 15, 328, "Input"],
Cell[92269, 2546, 395, 10, 42, "Text"],
Cell[92667, 2558, 479, 13, 42, "Text"],
Cell[93149, 2573, 381, 7, 35, "Text"],
Cell[93533, 2582, 73, 0, 41, "Text"],
Cell[93609, 2584, 1701, 39, 107, "Text"],
Cell[95313, 2625, 121, 4, 41, "Text"],

Cell[CellGroupData[{
Cell[95459, 2633, 31, 0, 68, "Exercise"],
Cell[95493, 2635, 257, 6, 67, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[95787, 2646, 31, 0, 68, "Exercise"],
Cell[95821, 2648, 646, 20, 101, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[96528, 2675, 63, 0, 93, "Section"],
Cell[96594, 2677, 2677, 73, 250, "Text"],
Cell[99274, 2752, 2492, 67, 290, "Text"],
Cell[101769, 2821, 619, 11, 202, "Input"],
Cell[102391, 2834, 263, 5, 150, "Input"],
Cell[102657, 2841, 306, 6, 150, "Input"],
Cell[102966, 2849, 238, 4, 150, "Input"],
Cell[103207, 2855, 332, 7, 67, "Text"],
Cell[103542, 2864, 496, 9, 150, "Input"],
Cell[104041, 2875, 350, 11, 67, "Text"],
Cell[104394, 2888, 75, 1, 72, "Input"],
Cell[104472, 2891, 83, 1, 41, "Text"],
Cell[104558, 2894, 1237, 22, 384, "Input"],
Cell[105798, 2918, 267, 9, 41, "Text"],
Cell[106068, 2929, 1514, 40, 89, "Text"],
Cell[107585, 2971, 1431, 39, 154, "Text"],
Cell[109019, 3012, 2573, 65, 112, "Text"],
Cell[111595, 3079, 649, 20, 93, "Text"],
Cell[112247, 3101, 759, 24, 62, "Text"],
Cell[113009, 3127, 730, 22, 67, "Text"],
Cell[113742, 3151, 1149, 30, 60, "Text"],
Cell[114894, 3183, 1321, 42, 119, "Text"],
Cell[116218, 3227, 1611, 41, 60, "Text"],
Cell[117832, 3270, 201, 8, 41, "Text"],
Cell[118036, 3280, 1904, 44, 116, "Text"],
Cell[119943, 3326, 727, 26, 42, "Text"],
Cell[120673, 3354, 638, 11, 145, "Text"],
Cell[121314, 3367, 821, 18, 145, "Text"],

Cell[CellGroupData[{
Cell[122160, 3389, 30, 0, 78, "Subsection"],
Cell[122193, 3391, 14336, 391, 1044, "Text"],

Cell[CellGroupData[{
Cell[136554, 3786, 31, 0, 68, "Exercise"],
Cell[136588, 3788, 258, 6, 67, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

